/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.DynamicMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.http.HttpClient;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FileBackedHTTPMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.UrlResource;

public class UrlResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicMetadataResolver.class);
    private final HttpClient httpClient;

    public UrlResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean, HttpClient httpClient) {
        super(samlIdPProperties, configBean);
        this.httpClient = httpClient;
    }

    @Override
    public Collection<MetadataResolver> resolve(SamlRegisteredService service) {
        try {
            String metadataLocation = service.getMetadataLocation();
            LOGGER.info("Loading SAML metadata from [{}]", (Object)metadataLocation);
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            File backupFile = this.getMetadataBackupFile(metadataResource, (RegisteredService)service);
            String canonicalPath = backupFile.getCanonicalPath();
            LOGGER.debug("Metadata backup file will be at [{}]", (Object)canonicalPath);
            FileUtils.forceMkdirParent((File)backupFile);
            FileBackedHTTPMetadataResolver metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClient.getWrappedHttpClient(), metadataResource.getURL().toExternalForm(), canonicalPath);
            this.buildSingleMetadataResolver((AbstractMetadataResolver)metadataProvider, service);
            return CollectionUtils.wrap((Object)metadataProvider);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ArrayList<MetadataResolver>(0);
        }
    }

    private File getMetadataBackupFile(AbstractResource metadataResource, RegisteredService service) throws IOException {
        SamlIdPProperties.Metadata md = this.samlIdPProperties.getMetadata();
        File backupDirectory = new File(md.getLocation().getFile(), "metadata-backups");
        LOGGER.debug("Metadata backup directory is at [{}]", (Object)backupDirectory.getCanonicalPath());
        String metadataFileName = service.getName().concat("-").concat(UUID.randomUUID().toString()).concat(metadataResource.getFilename());
        File backupFile = new File(backupDirectory, metadataFileName);
        if (backupFile.exists()) {
            LOGGER.warn("Metadata file designated for service [{}] already exists at path [{}].", (Object)service.getName(), (Object)backupFile.getCanonicalPath());
        } else {
            LOGGER.debug("Metadata to fetch for service [{}] will be placed at [{}]", (Object)service.getName(), (Object)backupFile.getCanonicalPath());
        }
        try {
            FileUtils.forceMkdir((File)backupDirectory);
            return backupFile;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to create metadata backup directory [{}]. This is likely due to a permission issue", (Object)backupDirectory);
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        try {
            String metadataLocation = service.getMetadataLocation();
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            return metadataResource instanceof UrlResource;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

