/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.flow;

import java.io.Serializable;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.mdui.MetadataUIUtils;
import org.apereo.cas.support.saml.mdui.SamlMetadataUIInfo;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SamlIdPMetadataUIAction
extends AbstractAction {
    private final ServicesManager servicesManager;
    private final SamlRegisteredServiceCachingMetadataResolver resolver;
    private final AuthenticationServiceSelectionPlan serviceSelectionStrategy;

    public SamlIdPMetadataUIAction(ServicesManager servicesManager, SamlRegisteredServiceCachingMetadataResolver resolver, AuthenticationServiceSelectionPlan serviceSelectionStrategy) {
        this.servicesManager = servicesManager;
        this.resolver = resolver;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
    }

    protected Event doExecute(RequestContext requestContext) {
        Service service = this.serviceSelectionStrategy.resolveService((Service)WebUtils.getService((RequestContext)requestContext));
        if (service != null) {
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            if (registeredService instanceof SamlRegisteredService) {
                SamlRegisteredService samlService = (SamlRegisteredService)SamlRegisteredService.class.cast(registeredService);
                Optional adaptor = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.resolver, (SamlRegisteredService)samlService, (String)service.getId());
                if (!adaptor.isPresent()) {
                    throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + service.getId());
                }
                SamlMetadataUIInfo mdui = MetadataUIUtils.locateMetadataUserInterfaceForEntityId((EntityDescriptor)((SamlRegisteredServiceServiceProviderMetadataFacade)adaptor.get()).getEntityDescriptor(), (String)service.getId(), (RegisteredService)registeredService, (HttpServletRequest)WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext));
                WebUtils.putServiceUserInterfaceMetadata((RequestContext)requestContext, (Serializable)mdui);
            }
        }
        return this.success();
    }
}

