/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.metadata;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.support.saml.web.idp.metadata.SamlIdpMetadataAndCertificatesGenerationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller(value="samlMetadataController")
public class SamlMetadataController {
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlMetadataController.class);
    private final SamlIdpMetadataAndCertificatesGenerationService metadataAndCertificatesGenerationService;

    public SamlMetadataController(SamlIdpMetadataAndCertificatesGenerationService metadataAndCertificatesGenerationService) {
        this.metadataAndCertificatesGenerationService = metadataAndCertificatesGenerationService;
    }

    @PostConstruct
    public void postConstruct() {
        this.metadataAndCertificatesGenerationService.performGenerationSteps();
    }

    @GetMapping(path={"/idp/metadata"})
    public void generateMetadataForIdp(HttpServletResponse response) throws IOException {
        File metadataFile = this.metadataAndCertificatesGenerationService.performGenerationSteps();
        String contents = FileUtils.readFileToString((File)metadataFile, (Charset)StandardCharsets.UTF_8);
        response.setContentType(CONTENT_TYPE);
        response.setStatus(200);
        try (PrintWriter writer = response.getWriter();){
            LOGGER.debug("Producing metadata for the response");
            writer.write(contents);
            writer.flush();
        }
    }
}

