/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.metadata;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.annotation.PostConstruct;
import net.shibboleth.utilities.java.support.security.SelfSignedCertificateGenerator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.web.idp.metadata.SamlIdpMetadataAndCertificatesGenerationService;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class TemplatedMetadataAndCertificatesGenerationService
implements SamlIdpMetadataAndCertificatesGenerationService {
    private static final String URI_SUBJECT_ALTNAME_POSTFIX = "/idp/metadata";
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplatedMetadataAndCertificatesGenerationService.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ResourceLoader resourceLoader;

    @PostConstruct
    public void initialize() {
        try {
            SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
            Resource metadataLocation = idp.getMetadata().getLocation();
            if (!metadataLocation.exists()) {
                LOGGER.debug("Metadata directory [{}] does not exist. Creating...", (Object)metadataLocation);
                if (!metadataLocation.getFile().mkdir()) {
                    throw new IllegalArgumentException("Metadata directory location " + metadataLocation + " cannot be located/created");
                }
            }
            LOGGER.info("Metadata directory location is at [{}] with entityID [{}]", (Object)metadataLocation, (Object)idp.getEntityId());
            this.performGenerationSteps();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isMetadataMissing() {
        try {
            SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
            return !idp.getMetadata().getMetadataFile().exists();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public File performGenerationSteps() {
        try {
            SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
            LOGGER.debug("Preparing to generate metadata for entityId [{}]", (Object)idp.getEntityId());
            if (this.isMetadataMissing()) {
                LOGGER.info("Metadata does not exist at [{}]. Creating...", (Object)idp.getMetadata().getMetadataFile());
                LOGGER.info("Creating self-sign certificate for signing...");
                this.buildSelfSignedSigningCert();
                LOGGER.info("Creating self-sign certificate for encryption...");
                this.buildSelfSignedEncryptionCert();
                LOGGER.info("Creating metadata...");
                this.buildMetadataGeneratorParameters();
            }
            LOGGER.info("Metadata is available at [{}]", (Object)idp.getMetadata().getMetadataFile());
            return idp.getMetadata().getMetadataFile();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String getIdPEndpointUrl() {
        return this.casProperties.getServer().getPrefix().concat("/idp");
    }

    private String getIdPHostName() {
        try {
            URL url = new URL(this.casProperties.getServer().getPrefix());
            return url.getHost();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void buildSelfSignedEncryptionCert() throws Exception {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        SelfSignedCertificateGenerator generator = new SelfSignedCertificateGenerator();
        generator.setHostName(this.getIdPHostName());
        generator.setCertificateFile(idp.getMetadata().getEncryptionCertFile().getFile());
        generator.setPrivateKeyFile(idp.getMetadata().getEncryptionKeyFile().getFile());
        generator.setURISubjectAltNames((Collection)CollectionUtils.wrap((Object)this.getIdPHostName().concat(URI_SUBJECT_ALTNAME_POSTFIX)));
        generator.generate();
    }

    protected void buildSelfSignedSigningCert() throws Exception {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        SelfSignedCertificateGenerator generator = new SelfSignedCertificateGenerator();
        generator.setHostName(this.getIdPHostName());
        generator.setCertificateFile(idp.getMetadata().getSigningCertFile().getFile());
        generator.setPrivateKeyFile(idp.getMetadata().getSigningKeyFile().getFile());
        generator.setURISubjectAltNames((Collection)CollectionUtils.wrap((Object)this.getIdPHostName().concat(URI_SUBJECT_ALTNAME_POSTFIX)));
        generator.generate();
    }

    protected void buildMetadataGeneratorParameters() throws Exception {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        Resource template = this.resourceLoader.getResource("classpath:/template-idp-metadata.xml");
        String signingKey = FileUtils.readFileToString((File)idp.getMetadata().getSigningCertFile().getFile(), (Charset)StandardCharsets.UTF_8);
        signingKey = StringUtils.remove((String)signingKey, (String)BEGIN_CERTIFICATE);
        signingKey = StringUtils.remove((String)signingKey, (String)END_CERTIFICATE).trim();
        String encryptionKey = FileUtils.readFileToString((File)idp.getMetadata().getEncryptionCertFile().getFile(), (Charset)StandardCharsets.UTF_8);
        encryptionKey = StringUtils.remove((String)encryptionKey, (String)BEGIN_CERTIFICATE);
        encryptionKey = StringUtils.remove((String)encryptionKey, (String)END_CERTIFICATE).trim();
        try (StringWriter writer = new StringWriter();){
            IOUtils.copy((InputStream)template.getInputStream(), (Writer)writer, (Charset)StandardCharsets.UTF_8);
            String metadata = writer.toString().replace("${entityId}", idp.getEntityId()).replace("${scope}", idp.getScope()).replace("${idpEndpointUrl}", this.getIdPEndpointUrl()).replace("${encryptionKey}", encryptionKey).replace("${signingKey}", signingKey);
            FileUtils.write((File)idp.getMetadata().getMetadataFile(), (CharSequence)metadata, (Charset)StandardCharsets.UTF_8);
        }
    }
}

