/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.BaseSamlObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectSignatureValidator;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPSOAP11Decoder;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

@Controller
public abstract class AbstractSamlProfileHandlerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlProfileHandlerController.class);
    protected AuthenticationSystemSupport authenticationSystemSupport;
    protected BaseSamlObjectSigner samlObjectSigner;
    protected SamlObjectSignatureValidator samlObjectSignatureValidator;
    protected ParserPool parserPool;
    protected Service callbackService;
    protected ServicesManager servicesManager;
    protected ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    protected SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver;
    protected OpenSamlConfigBean configBean;
    protected SamlProfileObjectBuilder<? extends SAMLObject> responseBuilder;
    protected CasConfigurationProperties casProperties;

    public AbstractSamlProfileHandlerController(BaseSamlObjectSigner samlObjectSigner, ParserPool parserPool, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver, OpenSamlConfigBean configBean, SamlProfileObjectBuilder<? extends SAMLObject> responseBuilder, CasConfigurationProperties casProperties, SamlObjectSignatureValidator samlObjectSignatureValidator) {
        this.samlObjectSigner = samlObjectSigner;
        this.parserPool = parserPool;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.samlRegisteredServiceCachingMetadataResolver = samlRegisteredServiceCachingMetadataResolver;
        this.configBean = configBean;
        this.responseBuilder = responseBuilder;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.samlObjectSignatureValidator = samlObjectSignatureValidator;
        this.casProperties = casProperties;
    }

    @PostConstruct
    protected void initialize() {
        this.callbackService = this.registerCallback("/idp/profile/SAML2/Callback");
    }

    protected Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, RequestAbstractType authnRequest) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
    }

    protected Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, String entityId) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)registeredService, (String)entityId);
    }

    protected SamlRegisteredService verifySamlRegisteredService(String serviceId) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Could not verify/locate SAML registered service since no serviceId is provided");
        }
        LOGGER.debug("Checking service access in CAS service registry for [{}]", (Object)serviceId);
        RegisteredService registeredService = this.servicesManager.findServiceBy(this.webApplicationServiceFactory.createService(serviceId));
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("[{}] is not found in the registry or service access is denied. Ensure service is registered in service registry", (Object)serviceId);
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        if (registeredService instanceof SamlRegisteredService) {
            SamlRegisteredService samlRegisteredService = (SamlRegisteredService)registeredService;
            LOGGER.debug("Located SAML service in the registry as [{}] with the metadata location of [{}]", (Object)samlRegisteredService.getServiceId(), (Object)samlRegisteredService.getMetadataLocation());
            return samlRegisteredService;
        }
        LOGGER.error("CAS has found a match for service [{}] in registry but the match is not defined as a SAML service", (Object)serviceId);
        throw new UnauthorizedServiceException("screen.service.error.message");
    }

    protected Service registerCallback(String callbackUrl) {
        Service callbackService = this.webApplicationServiceFactory.createService(this.casProperties.getServer().getPrefix().concat(callbackUrl.concat(".+")));
        if (!this.servicesManager.matchesExistingService(callbackService)) {
            LOGGER.debug("Initializing callback service [{}]", (Object)callbackService);
            RegexRegisteredService service = new RegexRegisteredService();
            service.setId(Math.abs(RandomUtils.getInstanceNative().nextLong()));
            service.setEvaluationOrder(0);
            service.setName(service.getClass().getSimpleName());
            service.setDescription("SAML Authentication Request");
            service.setServiceId(callbackService.getId());
            LOGGER.debug("Saving callback service [{}] into the registry", (Object)service);
            this.servicesManager.save((RegisteredService)service);
            this.servicesManager.load();
        }
        return callbackService;
    }

    protected AuthnRequest retrieveSamlAuthenticationRequestFromHttpRequest(HttpServletRequest request) throws Exception {
        LOGGER.debug("Retrieving authentication request from scope");
        String requestValue = request.getParameter("SAMLRequest");
        if (StringUtils.isBlank((CharSequence)requestValue)) {
            throw new IllegalArgumentException("SAML request could not be determined from the authentication request");
        }
        byte[] encodedRequest = EncodingUtils.decodeBase64((byte[])requestValue.getBytes(StandardCharsets.UTF_8));
        AuthnRequest authnRequest = (AuthnRequest)XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.configBean.getParserPool(), (InputStream)new ByteArrayInputStream(encodedRequest));
        return authnRequest;
    }

    protected Assertion buildCasAssertion(Authentication authentication, Service service, RegisteredService registeredService, Map<String, Object> attributesToCombine) {
        Map attributes = registeredService.getAttributeReleasePolicy().getAttributes(authentication.getPrincipal(), service, registeredService);
        AttributePrincipalImpl principal = new AttributePrincipalImpl(authentication.getPrincipal().getId(), attributes);
        LinkedHashMap<String, Object> authnAttrs = new LinkedHashMap<String, Object>(authentication.getAttributes());
        authnAttrs.putAll(attributesToCombine);
        return new AssertionImpl((AttributePrincipal)principal, DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate()), null, DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate()), authnAttrs);
    }

    protected Assertion buildCasAssertion(String principal, RegisteredService registeredService, Map<String, Object> attributes) {
        AttributePrincipalImpl p = new AttributePrincipalImpl(principal, attributes);
        return new AssertionImpl((AttributePrincipal)p, DateTimeUtils.dateOf((ChronoZonedDateTime)ZonedDateTime.now()), null, DateTimeUtils.dateOf((ChronoZonedDateTime)ZonedDateTime.now()), attributes);
    }

    protected org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> decodeSamlContextFromHttpRequest(HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder, Class<? extends SignableSAMLObject> clazz) {
        LOGGER.info("Received SAML profile request [{}]", (Object)request.getRequestURI());
        try {
            decoder.setHttpServletRequest(request);
            decoder.setParserPool(this.parserPool);
            decoder.initialize();
            decoder.decode();
            MessageContext messageContext = decoder.getMessageContext();
            SignableSAMLObject object = (SignableSAMLObject)messageContext.getMessage();
            if (object == null) {
                throw new SAMLException("No " + clazz.getName() + " could be found in this request context. Decoder has failed.");
            }
            if (!clazz.isAssignableFrom(object.getClass())) {
                throw new ClassCastException("SAML object [" + object.getClass().getName() + " type does not match " + clazz);
            }
            LOGGER.debug("Decoded SAML object [{}] from http request", (Object)object.getElementQName());
            return org.apache.commons.lang3.tuple.Pair.of((Object)object, (Object)messageContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void logCasValidationAssertion(Assertion assertion) {
        LOGGER.info("CAS Assertion Valid: [{}]", (Object)assertion.isValid());
        LOGGER.debug("CAS Assertion Principal: [{}]", (Object)assertion.getPrincipal().getName());
        LOGGER.debug("CAS Assertion AuthN Date: [{}]", (Object)assertion.getAuthenticationDate());
        LOGGER.debug("CAS Assertion ValidFrom Date: [{}]", (Object)assertion.getValidFromDate());
        LOGGER.debug("CAS Assertion ValidUntil Date: [{}]", (Object)assertion.getValidUntilDate());
        LOGGER.debug("CAS Assertion Attributes: [{}]", (Object)assertion.getAttributes());
        LOGGER.debug("CAS Assertion Principal Attributes: [{}]", (Object)assertion.getPrincipal().getAttributes());
    }

    protected void issueAuthenticationRequestRedirect(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)AuthnRequest.class.cast(pair.getLeft());
        String serviceUrl = this.constructServiceUrl(request, response, pair);
        LOGGER.debug("Created service url [{}]", (Object)serviceUrl);
        String initialUrl = CommonUtils.constructRedirectUrl((String)this.casProperties.getServer().getLoginUrl(), (String)"service", (String)serviceUrl, (boolean)authnRequest.isForceAuthn(), (boolean)authnRequest.isPassive());
        String urlToRedirectTo = this.buildRedirectUrlByRequestedAuthnContext(initialUrl, authnRequest, request);
        LOGGER.debug("Redirecting SAML authN request to [{}]", (Object)urlToRedirectTo);
        DefaultAuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
        authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
    }

    protected Map<String, String> getAuthenticationContextMappings() {
        TreeMap<String, String> mappings = new TreeMap<String, String>();
        this.casProperties.getAuthn().getSamlIdp().getAuthenticationContextClassMappings().stream().map(s -> {
            String[] bits = s.split("->");
            return org.apache.commons.lang3.tuple.Pair.of((Object)bits[0], (Object)bits[1]);
        }).forEach(p -> {
            String cfr_ignored_0 = (String)mappings.put((String)p.getKey(), (String)p.getValue());
        });
        return mappings;
    }

    protected String buildRedirectUrlByRequestedAuthnContext(String initialUrl, AuthnRequest authnRequest, HttpServletRequest request) {
        Set authenticationContextClassMappings = this.casProperties.getAuthn().getSamlIdp().getAuthenticationContextClassMappings();
        if (authnRequest.getRequestedAuthnContext() == null || authenticationContextClassMappings == null || authenticationContextClassMappings.isEmpty()) {
            return initialUrl;
        }
        Map<String, String> mappings = this.getAuthenticationContextMappings();
        Optional<AuthnContextClassRef> p = authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().stream().filter(ref -> {
            String clazz = ref.getAuthnContextClassRef();
            return mappings.containsKey(clazz);
        }).findFirst();
        if (p.isPresent()) {
            String mappedClazz = mappings.get(p.get().getAuthnContextClassRef());
            return initialUrl + '&' + this.casProperties.getAuthn().getMfa().getRequestParameter() + '=' + mappedClazz;
        }
        return initialUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair) throws SamlException {
        AuthnRequest authnRequest = (AuthnRequest)AuthnRequest.class.cast(pair.getLeft());
        MessageContext messageContext = (MessageContext)pair.getRight();
        try (StringWriter writer = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)authnRequest);){
            URLBuilder builder = new URLBuilder(this.callbackService.getId());
            builder.getQueryParams().add(new Pair((Object)"entityId", (Object)SamlIdPUtils.getIssuerFromSamlRequest((RequestAbstractType)authnRequest)));
            String samlRequest = EncodingUtils.encodeBase64((byte[])writer.toString().getBytes(StandardCharsets.UTF_8));
            builder.getQueryParams().add(new Pair((Object)"SAMLRequest", (Object)samlRequest));
            builder.getQueryParams().add(new Pair((Object)"RelayState", (Object)SAMLBindingSupport.getRelayState((MessageContext)messageContext)));
            String url = builder.buildURL();
            LOGGER.trace("Built service callback url [{}]", (Object)url);
            String string = CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)url, (String)this.casProperties.getServer().getName(), (String)"service", (String)"ticket", (boolean)false);
            return string;
        }
        catch (Exception e) {
            throw new SamlException(e.getMessage(), (Throwable)e);
        }
    }

    protected void initiateAuthenticationRequest(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.verifySamlAuthenticationRequest(pair, request);
        this.issueAuthenticationRequestRedirect(pair, request, response);
    }

    protected org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> verifySamlAuthenticationRequest(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> authenticationContext, HttpServletRequest request) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)AuthnRequest.class.cast(authenticationContext.getKey());
        String issuer = SamlIdPUtils.getIssuerFromSamlRequest((RequestAbstractType)authnRequest);
        LOGGER.debug("Located issuer [{}] from authentication request", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
        LOGGER.debug("Fetching saml metadata adaptor for [{}]", (Object)issuer);
        Optional adaptor = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
        if (!adaptor.isPresent()) {
            LOGGER.warn("No metadata could be found for [{}]", (Object)issuer);
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor.get();
        this.verifyAuthenticationContextSignature(authenticationContext, request, (RequestAbstractType)authnRequest, facade);
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)authnRequest);
        return org.apache.commons.lang3.tuple.Pair.of((Object)registeredService, (Object)facade);
    }

    protected void verifyAuthenticationContextSignature(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> authenticationContext, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws Exception {
        MessageContext ctx = (MessageContext)authenticationContext.getValue();
        this.verifyAuthenticationContextSignature(ctx, request, authnRequest, adaptor);
    }

    protected void verifyAuthenticationContextSignature(MessageContext ctx, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws Exception {
        if (!SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            LOGGER.debug("The authentication context is not signed");
            if (adaptor.isAuthnRequestsSigned()) {
                LOGGER.error("Metadata for [{}] says authentication requests are signed, yet authentication request is not", (Object)adaptor.getEntityId());
                throw new SAMLException("AuthN request is not signed but should be");
            }
            LOGGER.debug("Authentication request is not signed, so there is no need to verify its signature.");
        } else {
            LOGGER.debug("The authentication context is signed; Proceeding to validate signatures...");
            this.samlObjectSignatureValidator.verifySamlProfileRequestIfNeeded(authnRequest, adaptor, request, ctx);
        }
    }

    protected void buildSamlResponse(HttpServletResponse response, HttpServletRequest request, org.apache.commons.lang3.tuple.Pair<AuthnRequest, MessageContext> authenticationContext, Assertion casAssertion, String binding) {
        org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> pair = this.getRegisteredServiceAndFacade((AuthnRequest)authenticationContext.getKey());
        String entityId = ((SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue()).getEntityId();
        LOGGER.debug("Preparing SAML response for [{}]", (Object)entityId);
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        this.responseBuilder.build((RequestAbstractType)authnRequest, request, response, casAssertion, (SamlRegisteredService)pair.getKey(), (SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue(), binding);
        LOGGER.info("Built the SAML response for [{}]", (Object)entityId);
    }

    protected org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> getRegisteredServiceAndFacade(AuthnRequest request) {
        String issuer = SamlIdPUtils.getIssuerFromSamlRequest((RequestAbstractType)request);
        LOGGER.debug("Located issuer [{}] from authentication context", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
        LOGGER.debug("Located SAML metadata for [{}]", (Object)registeredService.getServiceId());
        Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(registeredService, (RequestAbstractType)request);
        if (!adaptor.isPresent()) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
        return org.apache.commons.lang3.tuple.Pair.of((Object)registeredService, (Object)facade);
    }

    protected MessageContext decodeSoapRequest(HttpServletRequest request) {
        try {
            HTTPSOAP11Decoder decoder = new HTTPSOAP11Decoder();
            decoder.setParserPool(this.parserPool);
            decoder.setHttpServletRequest(request);
            BindingDescriptor binding = new BindingDescriptor();
            binding.setId(this.getClass().getName());
            binding.setShortName(this.getClass().getName());
            binding.setSignatureCapable(true);
            binding.setSynchronous(true);
            decoder.setBindingDescriptor(binding);
            decoder.initialize();
            decoder.decode();
            return decoder.getMessageContext();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @ExceptionHandler(value={UnauthorizedServiceException.class})
    public ModelAndView handleUnauthorizedServiceException(HttpServletRequest req, Exception ex) {
        return WebUtils.produceUnauthorizedErrorView();
    }
}

