/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.artifact;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.CookieUtils;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.impl.BasicSAMLArtifactMap;

public class CasSamlArtifactMap
extends BasicSAMLArtifactMap {
    private final TicketRegistry ticketRegistry;
    private final SamlArtifactTicketFactory samlArtifactTicketFactory;
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;

    public CasSamlArtifactMap(TicketRegistry ticketRegistry, SamlArtifactTicketFactory samlArtifactTicketFactory, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketRegistry = ticketRegistry;
        this.samlArtifactTicketFactory = samlArtifactTicketFactory;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public void put(String artifact, String relyingPartyId, String issuerId, SAMLObject samlMessage) throws IOException {
        super.put(artifact, relyingPartyId, issuerId, samlMessage);
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator, (TicketRegistry)this.ticketRegistry, (HttpServletRequest)request);
        SamlArtifactTicket ticket = this.samlArtifactTicketFactory.create(artifact, ticketGrantingTicket.getAuthentication(), ticketGrantingTicket, issuerId, relyingPartyId, samlMessage);
        this.ticketRegistry.addTicket((Ticket)ticket);
    }
}

