/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.attr;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.springframework.beans.factory.annotation.Autowired;

public class SamlProfileSamlAttributeStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AttributeStatement> {
    private static final long serialVersionUID = 1815697787562189088L;
    @Autowired
    private CasConfigurationProperties casProperties;
    private final ProtocolAttributeEncoder samlAttributeEncoder;

    public SamlProfileSamlAttributeStatementBuilder(OpenSamlConfigBean configBean, ProtocolAttributeEncoder samlAttributeEncoder) {
        super(configBean);
        this.samlAttributeEncoder = samlAttributeEncoder;
    }

    @Override
    public AttributeStatement build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding) throws SamlException {
        return this.buildAttributeStatement(assertion, authnRequest, service, adaptor);
    }

    private AttributeStatement buildAttributeStatement(Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws SamlException {
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        HashMap attributes = new HashMap(assertion.getAttributes());
        attributes.putAll(assertion.getPrincipal().getAttributes());
        Map encodedAttrs = this.samlAttributeEncoder.encodeAttributes(attributes, (RegisteredService)service);
        SamlIdPProperties.Response resp = this.casProperties.getAuthn().getSamlIdp().getResponse();
        HashMap nameFormats = new HashMap(resp.configureAttributeNameFormats());
        nameFormats.putAll(service.getAttributeNameFormats());
        return this.newAttributeStatement(encodedAttrs, resp.isUseAttributeFriendlyName(), nameFormats, this.casProperties.getAuthn().getSamlIdp().getResponse().getDefaultAttributeNameFormat());
    }
}

