/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.authn;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthnContextClassRefBuilder
implements AuthnContextClassRefBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthnContextClassRefBuilder.class);
    private final CasConfigurationProperties casProperties;

    public DefaultAuthnContextClassRefBuilder(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    @Override
    public String build(Object assertion, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service) {
        RequestedAuthnContext requestedAuthnContext;
        if (StringUtils.isNotBlank((CharSequence)service.getRequiredAuthenticationContextClass())) {
            LOGGER.debug("Using [{}] as indicated by SAML registered service [{}]", (Object)service.getRequiredAuthenticationContextClass(), (Object)service.getName());
            return service.getRequiredAuthenticationContextClass();
        }
        String defClass = (String)StringUtils.defaultIfBlank((CharSequence)this.casProperties.getAuthn().getSamlIdp().getResponse().getDefaultAuthenticationContextClass(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext requestedAuthnContext2 = requestedAuthnContext = authnRequest instanceof AuthnRequest ? ((AuthnRequest)AuthnRequest.class.cast(authnRequest)).getRequestedAuthnContext() : null;
        if (requestedAuthnContext == null) {
            LOGGER.debug("No specific authN context is requested. Returning [{}]", (Object)defClass);
            return defClass;
        }
        List authnContextClassRefs = requestedAuthnContext.getAuthnContextClassRefs();
        if (authnContextClassRefs == null || authnContextClassRefs.isEmpty()) {
            LOGGER.debug("Requested authN context class ref is unspecified. Returning [{}]", (Object)defClass);
            return defClass;
        }
        String finalCtx = (String)StringUtils.defaultIfBlank((CharSequence)this.getAuthenticationContextByAssertion(assertion, requestedAuthnContext, authnContextClassRefs), (CharSequence)defClass);
        LOGGER.debug("Returning authN context [{}]", (Object)finalCtx);
        return finalCtx;
    }

    protected String getAuthenticationContextByAssertion(Object assertion, RequestedAuthnContext requestedAuthnContext, List<AuthnContextClassRef> authnContextClassRefs) {
        LOGGER.debug("AuthN Context comparison is requested to use [{}]", (Object)requestedAuthnContext.getComparison());
        authnContextClassRefs.forEach(c -> LOGGER.debug("Requested AuthN Context [{}]", (Object)c.getAuthnContextClassRef()));
        return null;
    }
}

