/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.authn;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.AuthnContextClassRefBuilder;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.InetAddressUtils;
import org.apereo.cas.util.RandomUtils;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.springframework.beans.factory.annotation.Autowired;

public class SamlProfileSamlAuthNStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AuthnStatement> {
    private static final long serialVersionUID = 8761566449790497226L;
    @Autowired
    private CasConfigurationProperties casProperties;
    private final AuthnContextClassRefBuilder authnContextClassRefBuilder;

    public SamlProfileSamlAuthNStatementBuilder(OpenSamlConfigBean configBean, AuthnContextClassRefBuilder authnContextClassRefBuilder) {
        super(configBean);
        this.authnContextClassRefBuilder = authnContextClassRefBuilder;
    }

    @Override
    public AuthnStatement build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding) throws SamlException {
        return this.buildAuthnStatement(assertion, authnRequest, adaptor, service, binding);
    }

    private AuthnStatement buildAuthnStatement(Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service, String binding) throws SamlException {
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        String authenticationMethod = this.authnContextClassRefBuilder.build(assertion, authnRequest, adaptor, service);
        String id = '_' + String.valueOf(Math.abs(RandomUtils.getInstanceNative().nextLong()));
        AuthnStatement statement = this.newAuthnStatement(authenticationMethod, DateTimeUtils.zonedDateTimeOf((Date)assertion.getAuthenticationDate()), id);
        if (assertion.getValidUntilDate() != null) {
            ZonedDateTime dt = DateTimeUtils.zonedDateTimeOf((Date)assertion.getValidUntilDate());
            statement.setSessionNotOnOrAfter(DateTimeUtils.dateTimeOf((ChronoZonedDateTime)dt.plusSeconds(this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance())));
        }
        statement.setSubjectLocality(this.buildSubjectLocality(assertion, authnRequest, adaptor, binding));
        return statement;
    }

    protected SubjectLocality buildSubjectLocality(Object assertion, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding) throws SamlException {
        String ip;
        SubjectLocality subjectLocality = (SubjectLocality)this.newSamlObject(SubjectLocality.class);
        AssertionConsumerService acs = adaptor.getAssertionConsumerService(binding);
        if (acs != null && StringUtils.isNotBlank((CharSequence)acs.getLocation()) && StringUtils.isNotBlank((CharSequence)(ip = InetAddressUtils.getByName((String)acs.getLocation())))) {
            subjectLocality.setAddress(ip);
        }
        return subjectLocality;
    }
}

