/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.conditions;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.springframework.beans.factory.annotation.Autowired;

public class SamlProfileSamlConditionsBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Conditions> {
    private static final long serialVersionUID = 126393045912318783L;
    @Autowired
    private CasConfigurationProperties casProperties;

    public SamlProfileSamlConditionsBuilder(OpenSamlConfigBean configBean) {
        super(configBean);
    }

    @Override
    public Conditions build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding) throws SamlException {
        return this.buildConditions(authnRequest, assertion, service, adaptor);
    }

    protected Conditions buildConditions(RequestAbstractType authnRequest, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws SamlException {
        ZonedDateTime currentDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        int skewAllowance = this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance();
        if (skewAllowance <= 0) {
            skewAllowance = this.casProperties.getSamlCore().getSkewAllowance();
        }
        Conditions conditions = this.newConditions(currentDateTime, currentDateTime.plusSeconds(skewAllowance), adaptor.getEntityId());
        return conditions;
    }
}

