/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.ui.velocity.VelocityEngineFactory;

public abstract class BaseSamlResponseEncoder {
    protected final VelocityEngineFactory velocityEngineFactory;
    protected final SamlRegisteredServiceServiceProviderMetadataFacade adaptor;
    protected final HttpServletResponse httpResponse;
    protected final HttpServletRequest httpRequest;

    public BaseSamlResponseEncoder(VelocityEngineFactory velocityEngineFactory, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletResponse httpResponse, HttpServletRequest httpRequest) {
        this.velocityEngineFactory = velocityEngineFactory;
        this.adaptor = adaptor;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
    }

    public final Response encode(Response samlResponse, String relayState) throws SamlException {
        try {
            if (this.httpResponse != null) {
                BaseSAML2MessageEncoder encoder = this.getMessageEncoderInstance();
                encoder.setHttpServletResponse(this.httpResponse);
                MessageContext ctx = this.getEncoderMessageContext(samlResponse, relayState);
                encoder.setMessageContext(ctx);
                this.finalizeEncode(encoder, samlResponse, relayState);
            }
            return samlResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected MessageContext getEncoderMessageContext(Response samlResponse, String relayState) {
        MessageContext ctx = new MessageContext();
        ctx.setMessage((Object)samlResponse);
        SAMLBindingSupport.setRelayState((MessageContext)ctx, (String)relayState);
        SamlIdPUtils.preparePeerEntitySamlEndpointContext((MessageContext)ctx, (SamlRegisteredServiceServiceProviderMetadataFacade)this.adaptor, (String)this.getBinding());
        SAMLSelfEntityContext self = (SAMLSelfEntityContext)ctx.getSubcontext(SAMLSelfEntityContext.class, true);
        self.setEntityId(samlResponse.getIssuer().getValue());
        return ctx;
    }

    protected void finalizeEncode(BaseSAML2MessageEncoder encoder, Response samlResponse, String relayState) throws Exception {
        encoder.initialize();
        encoder.encode();
    }

    protected abstract String getBinding();

    protected abstract BaseSAML2MessageEncoder getMessageEncoderInstance() throws Exception;
}

