/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlAttributeEncoder
implements ProtocolAttributeEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlAttributeEncoder.class);

    public Map<String, Object> encodeAttributes(Map<String, Object> attributes, RegisteredService service) {
        HashMap<String, Object> finalAttributes = new HashMap<String, Object>(attributes.size());
        attributes.forEach((k, v) -> {
            String attributeName = EncodingUtils.hexDecode((String)k);
            if (StringUtils.isNotBlank((CharSequence)attributeName)) {
                LOGGER.debug("Decoded SAML attribute [{}] to [{}] with value(s) [{}]", new Object[]{k, attributeName, v});
                finalAttributes.put(attributeName, v);
            } else {
                LOGGER.debug("Unable to decode SAML attribute [{}]; accepting it verbatim", k);
                finalAttributes.put((String)k, v);
            }
        });
        return finalAttributes;
    }
}

