/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.BaseSamlObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectEncrypter;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlResponseArtifactEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlResponsePostEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlResponsePostSimpleSignEncoder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.BaseSamlProfileSamlResponseBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.CookieUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.velocity.VelocityEngineFactory;

public class SamlProfileSaml2ResponseBuilder
extends BaseSamlProfileSamlResponseBuilder<Response> {
    private static final long serialVersionUID = 1488837627964481272L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSaml2ResponseBuilder.class);
    private final TicketRegistry ticketRegistry;
    private final SamlArtifactTicketFactory samlArtifactTicketFactory;
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private final SAMLArtifactMap samlArtifactMap;
    private final SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory;

    public SamlProfileSaml2ResponseBuilder(OpenSamlConfigBean openSamlConfigBean, BaseSamlObjectSigner samlObjectSigner, VelocityEngineFactory velocityEngineFactory, SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, SamlObjectEncrypter samlObjectEncrypter, TicketRegistry ticketRegistry, SamlArtifactTicketFactory samlArtifactTicketFactory, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, SAMLArtifactMap samlArtifactMap, SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory) {
        super(openSamlConfigBean, samlObjectSigner, velocityEngineFactory, samlProfileSamlAssertionBuilder, samlObjectEncrypter);
        this.ticketRegistry = ticketRegistry;
        this.samlArtifactTicketFactory = samlArtifactTicketFactory;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.samlArtifactMap = samlArtifactMap;
        this.samlAttributeQueryTicketFactory = samlAttributeQueryTicketFactory;
    }

    @Override
    protected Response buildResponse(Assertion assertion, Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest request, HttpServletResponse response, String binding) throws SamlException {
        SAMLObject finalAssertion;
        String id = '_' + String.valueOf(Math.abs(RandomUtils.getInstanceNative().nextLong()));
        Response samlResponse = this.newResponse(id, ZonedDateTime.now(ZoneOffset.UTC), authnRequest.getID(), null);
        samlResponse.setVersion(SAMLVersion.VERSION_20);
        samlResponse.setIssuer(this.buildEntityIssuer());
        if (this.casProperties.getAuthn().getSamlIdp().isAttributeQueryProfileEnabled()) {
            this.storeAttributeQueryTicketInRegistry(assertion, request, adaptor);
        }
        if ((finalAssertion = this.encryptAssertion(assertion, request, response, service, adaptor)) instanceof EncryptedAssertion) {
            LOGGER.debug("Built assertion is encrypted, so the response will add it to the encrypted assertions collection");
            samlResponse.getEncryptedAssertions().add(EncryptedAssertion.class.cast(finalAssertion));
        } else {
            LOGGER.debug("Built assertion is not encrypted, so the response will add it to the assertions collection");
            samlResponse.getAssertions().add(Assertion.class.cast(finalAssertion));
        }
        Status status = this.newStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null);
        samlResponse.setStatus(status);
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlResponse);
        if (service.isSignResponses()) {
            LOGGER.debug("SAML entity id [{}] indicates that SAML responses should be signed", (Object)adaptor.getEntityId());
            samlResponse = this.samlObjectSigner.encode(samlResponse, service, adaptor, response, request, binding);
            SamlUtils.logSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlResponse);
        }
        return samlResponse;
    }

    @Override
    protected Response encode(SamlRegisteredService service, Response samlResponse, HttpServletResponse httpResponse, HttpServletRequest httpRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String relayState, String binding, RequestAbstractType authnRequest, Object assertion) throws SamlException {
        LOGGER.debug("Constructing encoder based on binding [{}] for [{}]", (Object)binding, (Object)adaptor.getEntityId());
        if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact")) {
            SamlResponseArtifactEncoder encoder = new SamlResponseArtifactEncoder(this.velocityEngineFactory, adaptor, httpRequest, httpResponse, authnRequest, this.ticketRegistry, this.samlArtifactTicketFactory, this.ticketGrantingTicketCookieGenerator, this.samlArtifactMap);
            return encoder.encode(samlResponse, relayState);
        }
        if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign")) {
            SamlResponsePostSimpleSignEncoder encoder = new SamlResponsePostSimpleSignEncoder(this.velocityEngineFactory, adaptor, httpResponse, httpRequest);
            return encoder.encode(samlResponse, relayState);
        }
        SamlResponsePostEncoder encoder = new SamlResponsePostEncoder(this.velocityEngineFactory, adaptor, httpResponse, httpRequest);
        return encoder.encode(samlResponse, relayState);
    }

    private void storeAttributeQueryTicketInRegistry(Assertion assertion, HttpServletRequest request, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        String value = assertion.getSubject().getNameID().getValue();
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator, (TicketRegistry)this.ticketRegistry, (HttpServletRequest)request);
        SamlAttributeQueryTicket ticket = this.samlAttributeQueryTicketFactory.create(value, (SAMLObject)assertion, adaptor.getEntityId(), ticketGrantingTicket);
        this.ticketRegistry.addTicket((Ticket)ticket);
    }
}

