/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response.soap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.BaseSamlObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectEncrypter;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.BaseSamlProfileSamlResponseBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPSOAP11Encoder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.ecp.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.velocity.VelocityEngineFactory;

public class SamlProfileSamlSoap11ResponseBuilder
extends BaseSamlProfileSamlResponseBuilder<Envelope> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlSoap11ResponseBuilder.class);
    private static final long serialVersionUID = -1875903354216171261L;
    protected final SamlProfileObjectBuilder<? extends SAMLObject> saml2ResponseBuilder;

    public SamlProfileSamlSoap11ResponseBuilder(OpenSamlConfigBean openSamlConfigBean, BaseSamlObjectSigner samlObjectSigner, VelocityEngineFactory velocityEngineFactory, SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, SamlProfileObjectBuilder<? extends SAMLObject> saml2ResponseBuilder, SamlObjectEncrypter samlObjectEncrypter) {
        super(openSamlConfigBean, samlObjectSigner, velocityEngineFactory, samlProfileSamlAssertionBuilder, samlObjectEncrypter);
        this.saml2ResponseBuilder = saml2ResponseBuilder;
    }

    @Override
    protected Envelope buildResponse(Assertion assertion, Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest request, HttpServletResponse response, String binding) throws SamlException {
        AssertionConsumerService acs = adaptor.getAssertionConsumerService(binding);
        if (acs == null) {
            LOGGER.warn("Could not locate the assertion consumer service url for binding [{}]", (Object)binding);
            throw new IllegalArgumentException("Failed to locate the assertion consumer service url for " + binding);
        }
        LOGGER.debug("Located assertion consumer service url [{}]", (Object)acs);
        Response ecpResponse = this.newEcpResponse(acs.getLocation());
        Header header = (Header)this.newSoapObject(Header.class);
        header.getUnknownXMLObjects().add(ecpResponse);
        Body body = (Body)this.newSoapObject(Body.class);
        org.opensaml.saml.saml2.core.Response saml2Response = this.buildSaml2Response(casAssertion, authnRequest, service, adaptor, request, binding);
        body.getUnknownXMLObjects().add(saml2Response);
        Envelope envelope = (Envelope)this.newSoapObject(Envelope.class);
        envelope.setHeader(header);
        envelope.setBody(body);
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)envelope);
        return envelope;
    }

    protected org.opensaml.saml.saml2.core.Response buildSaml2Response(Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest request, String binding) {
        return (org.opensaml.saml.saml2.core.Response)this.saml2ResponseBuilder.build(authnRequest, request, null, casAssertion, service, adaptor, binding);
    }

    @Override
    protected Envelope encode(SamlRegisteredService service, Envelope envelope, HttpServletResponse httpResponse, HttpServletRequest httpRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String relayState, String binding, RequestAbstractType authnRequest, Object assertion) throws SamlException {
        try {
            MessageContext result = new MessageContext();
            SOAP11Context ctx = (SOAP11Context)result.getSubcontext(SOAP11Context.class, true);
            ctx.setEnvelope(envelope);
            HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
            encoder.setHttpServletResponse(httpResponse);
            encoder.setMessageContext(result);
            encoder.initialize();
            encoder.encode();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return envelope;
    }
}

