/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.artifact;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;

@Entity
@Table(name="SAML2_ARTIFACTS")
@DiscriminatorColumn(name="TYPE")
@DiscriminatorValue(value="SART")
public class SamlArtifactTicketImpl
extends AbstractTicket
implements SamlArtifactTicket {
    private static final long serialVersionUID = 6276140828446447398L;
    @Column(length=500, updatable=true, insertable=true)
    private String issuer;
    @Column(length=500, updatable=true, insertable=true)
    private String relyingParty;
    @Column(length=5000, updatable=true, insertable=true)
    private String samlObject;
    @ManyToOne(targetEntity=TicketGrantingTicketImpl.class)
    @JsonProperty(value="grantingTicket")
    private TicketGrantingTicket ticketGrantingTicket;
    @Lob
    @Column(name="SERVICE", nullable=false)
    private Service service;
    @Lob
    @Column(name="AUTHENTICATION", nullable=false, length=1000000)
    private Authentication authentication;

    public SamlArtifactTicketImpl() {
    }

    public SamlArtifactTicketImpl(String id, Service service, Authentication authentication, ExpirationPolicy expirationPolicy, TicketGrantingTicket ticketGrantingTicket, String issuer, String relyingParty, String samlObject) {
        super(id, expirationPolicy);
        this.service = service;
        this.authentication = authentication;
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.relyingParty = relyingParty;
        this.issuer = issuer;
        this.samlObject = samlObject;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getRelyingPartyId() {
        return this.relyingParty;
    }

    @Override
    public String getObject() {
        return this.samlObject;
    }

    public boolean isFromNewLogin() {
        return true;
    }

    public Service getService() {
        return this.service;
    }

    public boolean isValidFor(Service serviceToValidate) {
        this.update();
        return serviceToValidate.matches(this.service);
    }

    public ProxyGrantingTicket grantProxyGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        throw new UnsupportedOperationException("No PGT grant is available");
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public TicketGrantingTicket getGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public String getPrefix() {
        return "SART";
    }
}

