/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.query;

import java.io.StringWriter;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketImpl;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;

public class DefaultSamlAttributeQueryTicketFactory
implements SamlAttributeQueryTicketFactory {
    protected final ExpirationPolicy expirationPolicy;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    protected final OpenSamlConfigBean configBean;

    public DefaultSamlAttributeQueryTicketFactory(ExpirationPolicy expirationPolicy, OpenSamlConfigBean configBean, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        this.expirationPolicy = expirationPolicy;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.configBean = configBean;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SamlAttributeQueryTicket create(String id, SAMLObject samlObject, String relyingParty, TicketGrantingTicket ticketGrantingTicket) {
        try (StringWriter w = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlObject);){
            String codeId = this.createTicketIdFor(id);
            Service service = this.webApplicationServiceFactory.createService(relyingParty);
            SamlAttributeQueryTicketImpl at = new SamlAttributeQueryTicketImpl(codeId, service, this.expirationPolicy, relyingParty, w.toString(), ticketGrantingTicket);
            if (ticketGrantingTicket != null) {
                ticketGrantingTicket.getDescendantTickets().add(at.getId());
            }
            SamlAttributeQueryTicketImpl samlAttributeQueryTicketImpl = at;
            return samlAttributeQueryTicketImpl;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }
}

