/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;

@Entity
@Table(name="SAML2_ATTRIBUTE_QUERY_TICKETS")
@DiscriminatorColumn(name="TYPE")
@DiscriminatorValue(value="SATQ")
public class SamlAttributeQueryTicketImpl
extends AbstractTicket
implements SamlAttributeQueryTicket {
    private static final long serialVersionUID = 6276140828446447398L;
    @Column(length=255, updatable=true, insertable=true)
    private String relyingParty;
    @Column(length=5000, updatable=true, insertable=true)
    private String samlObject;
    @ManyToOne(targetEntity=TicketGrantingTicketImpl.class)
    @JsonProperty(value="grantingTicket")
    private TicketGrantingTicket ticketGrantingTicket;
    @Lob
    @Column(name="SERVICE", nullable=false)
    private Service service;

    public SamlAttributeQueryTicketImpl() {
    }

    public SamlAttributeQueryTicketImpl(String id, Service service, ExpirationPolicy expirationPolicy, String relyingParty, String samlObject, TicketGrantingTicket ticketGrantingTicket) {
        super(id, expirationPolicy);
        this.service = service;
        this.relyingParty = relyingParty;
        this.samlObject = samlObject;
        this.ticketGrantingTicket = ticketGrantingTicket;
    }

    @Override
    public String getObject() {
        return this.samlObject;
    }

    @Override
    public String getRelyingParty() {
        return this.relyingParty;
    }

    public void setRelyingParty(String relyingParty) {
        this.relyingParty = relyingParty;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public boolean isFromNewLogin() {
        return true;
    }

    public Service getService() {
        return this.service;
    }

    public boolean isValidFor(Service serviceToValidate) {
        this.update();
        return serviceToValidate.matches(this.service);
    }

    public ProxyGrantingTicket grantProxyGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        throw new UnsupportedOperationException("No PGT grant is available");
    }

    public Authentication getAuthentication() {
        return this.ticketGrantingTicket.getAuthentication();
    }

    public TicketGrantingTicket getGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public String getPrefix() {
        return "SATQ";
    }
}

