/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPAlgorithmsProperties;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlan;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlIdPServiceRegistry;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.IdPInitiatedProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.artifact.Saml1ArtifactResolutionProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.ecp.ECPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.query.Saml2AttributeQueryProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SLOSamlPostProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SLOSamlRedirectProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlPostProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlPostSimpleSignProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlProfileCallbackHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.DefaultSSOSamlHttpRequestExtractor;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.SSOSamlHttpRequestExtractor;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.ecp.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="samlIdPEndpointsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPEndpointsConfiguration
implements ServiceRegistryExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPEndpointsConfiguration.class);
    @Autowired
    @Qualifier(value="casClientTicketValidator")
    private AbstractUrlBasedTicketValidator casClientTicketValidator;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean openSamlConfigBean;
    @Autowired
    @Qualifier(value="samlProfileSamlResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder;
    @Autowired
    @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver")
    private SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="samlObjectSigner")
    private SamlIdPObjectSigner samlObjectSigner;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CookieRetrievingCookieGenerator> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="casSamlIdPMetadataResolver")
    private MetadataResolver casSamlIdPMetadataResolver;
    @Autowired
    @Qualifier(value="samlProfileSamlSoap11ResponseBuilder")
    private SamlProfileObjectBuilder<Response> samlProfileSamlSoap11ResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlSoap11FaultResponseBuilder")
    private SamlProfileObjectBuilder<Response> samlProfileSamlSoap11FaultResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlArtifactResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlArtifactResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlArtifactFaultResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlArtifactFaultResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlAttributeQueryResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlAttributeQueryResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlAttributeQueryFaultResponseBuilder")
    private SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlAttributeQueryFaultResponseBuilder;
    @Autowired
    @Qualifier(value="samlAttributeQueryTicketFactory")
    private SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="samlArtifactTicketFactory")
    private ObjectProvider<SamlArtifactTicketFactory> samlArtifactTicketFactory;

    @ConditionalOnMissingBean(name={"samlIdPObjectSignatureValidator"})
    @Bean
    public SamlObjectSignatureValidator samlIdPObjectSignatureValidator() {
        SamlIdPAlgorithmsProperties algs = this.casProperties.getAuthn().getSamlIdp().getAlgs();
        return new SamlIdPObjectSignatureValidator(algs.getOverrideSignatureReferenceDigestMethods(), algs.getOverrideSignatureAlgorithms(), algs.getOverrideBlackListedSignatureSigningAlgorithms(), algs.getOverrideWhiteListedSignatureSigningAlgorithms(), this.casSamlIdPMetadataResolver, this.casProperties);
    }

    @ConditionalOnMissingBean(name={"samlObjectSignatureValidator"})
    @Bean
    public SamlObjectSignatureValidator samlObjectSignatureValidator() {
        SamlIdPAlgorithmsProperties algs = this.casProperties.getAuthn().getSamlIdp().getAlgs();
        return new SamlObjectSignatureValidator(algs.getOverrideSignatureReferenceDigestMethods(), algs.getOverrideSignatureAlgorithms(), algs.getOverrideBlackListedSignatureSigningAlgorithms(), algs.getOverrideWhiteListedSignatureSigningAlgorithms(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"ssoSamlHttpRequestExtractor"})
    @Bean
    public SSOSamlHttpRequestExtractor ssoSamlHttpRequestExtractor() {
        return new DefaultSSOSamlHttpRequestExtractor(this.openSamlConfigBean.getParserPool());
    }

    @Bean
    @RefreshScope
    public SSOSamlPostProfileHandlerController ssoPostProfileHandlerController() {
        return new SSOSamlPostProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.ssoSamlHttpRequestExtractor(), this.samlIdPCallbackService());
    }

    @Bean
    @RefreshScope
    public SSOSamlPostSimpleSignProfileHandlerController ssoPostSimpleSignProfileHandlerController() {
        return new SSOSamlPostSimpleSignProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.ssoSamlHttpRequestExtractor(), this.samlIdPCallbackService());
    }

    @Bean
    @RefreshScope
    public SLOSamlRedirectProfileHandlerController sloRedirectProfileHandlerController() {
        return new SLOSamlRedirectProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.ssoSamlHttpRequestExtractor(), this.samlIdPCallbackService());
    }

    @Bean
    @RefreshScope
    public SLOSamlPostProfileHandlerController sloPostProfileHandlerController() {
        return new SLOSamlPostProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.ssoSamlHttpRequestExtractor(), this.samlIdPCallbackService());
    }

    @Bean
    @RefreshScope
    public IdPInitiatedProfileHandlerController idPInitiatedSamlProfileHandlerController() {
        return new IdPInitiatedProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlIdPObjectSignatureValidator(), this.samlIdPCallbackService());
    }

    @Bean
    @RefreshScope
    public SSOSamlProfileCallbackHandlerController ssoPostProfileCallbackHandlerController() {
        return new SSOSamlProfileCallbackHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.casClientTicketValidator, this.samlIdPCallbackService());
    }

    @Bean
    @RefreshScope
    public ECPProfileHandlerController ecpProfileHandlerController() {
        return new ECPProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlSoap11ResponseBuilder, this.samlProfileSamlSoap11FaultResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.samlIdPCallbackService());
    }

    @Bean
    @RefreshScope
    public Saml1ArtifactResolutionProfileHandlerController saml1ArtifactResolutionController() {
        return new Saml1ArtifactResolutionProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlArtifactResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.ticketRegistry, (SamlArtifactTicketFactory)this.samlArtifactTicketFactory.getIfAvailable(), this.samlProfileSamlArtifactFaultResponseBuilder, this.samlIdPCallbackService());
    }

    @ConditionalOnProperty(prefix="cas.authn.samlIdp", name={"attributeQueryProfileEnabled"}, havingValue="true")
    @Bean
    @RefreshScope
    public Saml2AttributeQueryProfileHandlerController saml2AttributeQueryProfileHandlerController() {
        return new Saml2AttributeQueryProfileHandlerController(this.samlObjectSigner, this.openSamlConfigBean.getParserPool(), this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory, this.defaultSamlRegisteredServiceCachingMetadataResolver, this.openSamlConfigBean, this.samlProfileSamlAttributeQueryResponseBuilder, this.casProperties, this.samlObjectSignatureValidator(), this.ticketRegistry, this.samlProfileSamlAttributeQueryFaultResponseBuilder, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.samlAttributeQueryTicketFactory, this.samlIdPCallbackService());
    }

    @Bean
    public Service samlIdPCallbackService() {
        String service = this.casProperties.getServer().getPrefix().concat("/idp/profile/SAML2/Callback".concat(".+"));
        return this.webApplicationServiceFactory.createService(service);
    }

    public void configureServiceRegistry(ServiceRegistryExecutionPlan plan) {
        Service callbackService = this.samlIdPCallbackService();
        LOGGER.debug("Initializing callback service [{}]", (Object)callbackService);
        RegexRegisteredService service = new RegexRegisteredService();
        service.setId(Math.abs(RandomUtils.getNativeInstance().nextLong()));
        service.setEvaluationOrder(0);
        service.setName(service.getClass().getSimpleName());
        service.setDescription("SAML Authentication Request");
        service.setServiceId(callbackService.getId());
        plan.registerServiceRegistry((ServiceRegistry)new SamlIdPServiceRegistry(new RegisteredService[]{service}));
    }
}

