/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.net.URL;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.metadata.generator.FileSystemSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.locator.DefaultSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.writer.DefaultSamlIdPCertificateAndKeyWriter;
import org.apereo.cas.support.saml.idp.metadata.writer.SamlIdPCertificateAndKeyWriter;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceDefaultCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataResolverCacheLoader;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.ClasspathResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.DynamicMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.FileSystemResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.GroovyResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.UrlResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.DefaultSamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlanConfigurator;
import org.apereo.cas.support.saml.web.idp.metadata.SamlIdPMetadataController;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ResourceLoader;

@Configuration(value="samlIdPMetadataConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPMetadataConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataConfiguration.class);
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="noRedirectHttpClient")
    private HttpClient httpClient;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean openSamlConfigBean;

    @Lazy
    @Bean(initMethod="initialize", destroyMethod="destroy")
    @DependsOn(value={"samlIdPMetadataGenerator"})
    @Autowired
    public MetadataResolver casSamlIdPMetadataResolver(@Qualifier(value="samlMetadataLocator") SamlIdPMetadataLocator samlMetadataLocator) {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        InMemoryResourceMetadataResolver resolver = new InMemoryResourceMetadataResolver(samlMetadataLocator.getMetadata(), this.openSamlConfigBean);
        resolver.setParserPool(this.openSamlConfigBean.getParserPool());
        resolver.setFailFastInitialization(idp.getMetadata().isFailFast());
        resolver.setRequireValidMetadata(idp.getMetadata().isRequireValidMetadata());
        resolver.setId(idp.getEntityId());
        return resolver;
    }

    @Bean
    @RefreshScope
    public SamlIdPMetadataController samlIdPMetadataController() {
        return new SamlIdPMetadataController(this.samlIdPMetadataGenerator(), this.samlMetadataLocator());
    }

    @ConditionalOnMissingBean(name={"samlIdPMetadataGenerator"})
    @Bean
    public SamlIdPMetadataGenerator samlIdPMetadataGenerator() {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        return new FileSystemSamlIdPMetadataGenerator(idp.getEntityId(), this.resourceLoader, this.casProperties.getServer().getPrefix(), idp.getScope(), this.samlMetadataLocator(), this.samlSelfSignedCertificateWriter());
    }

    @ConditionalOnMissingBean(name={"samlSelfSignedCertificateWriter"})
    @Bean
    public SamlIdPCertificateAndKeyWriter samlSelfSignedCertificateWriter() {
        URL url = new URL(this.casProperties.getServer().getPrefix());
        DefaultSamlIdPCertificateAndKeyWriter generator = new DefaultSamlIdPCertificateAndKeyWriter();
        generator.setHostname(url.getHost());
        generator.setUriSubjectAltNames(CollectionUtils.wrap((Object)url.getHost().concat("/idp/metadata")));
        return generator;
    }

    @ConditionalOnMissingBean(name={"samlMetadataLocator"})
    @Bean
    public SamlIdPMetadataLocator samlMetadataLocator() {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        return new DefaultSamlIdPMetadataLocator(idp.getMetadata().getLocation());
    }

    @ConditionalOnMissingBean(name={"chainingMetadataResolverCacheLoader"})
    @Bean
    @RefreshScope
    public SamlRegisteredServiceMetadataResolverCacheLoader chainingMetadataResolverCacheLoader() {
        return new SamlRegisteredServiceMetadataResolverCacheLoader(this.openSamlConfigBean, this.httpClient, this.samlRegisteredServiceMetadataResolvers());
    }

    @ConditionalOnMissingBean(name={"samlRegisteredServiceMetadataResolvers"})
    @Bean
    public SamlRegisteredServiceMetadataResolutionPlan samlRegisteredServiceMetadataResolvers() {
        DefaultSamlRegisteredServiceMetadataResolutionPlan plan = new DefaultSamlRegisteredServiceMetadataResolutionPlan();
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new DynamicMetadataResolver(samlIdp, this.openSamlConfigBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new FileSystemResourceMetadataResolver(samlIdp, this.openSamlConfigBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new UrlResourceMetadataResolver(samlIdp, this.openSamlConfigBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new ClasspathResourceMetadataResolver(samlIdp, this.openSamlConfigBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new GroovyResourceMetadataResolver(samlIdp, this.openSamlConfigBean));
        Map configurers = this.applicationContext.getBeansOfType(SamlRegisteredServiceMetadataResolutionPlanConfigurator.class, false, true);
        configurers.values().forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Configuring saml metadata resolution plan [{}]", (Object)name);
            c.configureMetadataResolutionPlan((SamlRegisteredServiceMetadataResolutionPlan)plan);
        });
        return plan;
    }

    @ConditionalOnMissingBean(name={"defaultSamlRegisteredServiceCachingMetadataResolver"})
    @Bean
    @RefreshScope
    public SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver() {
        return new SamlRegisteredServiceDefaultCachingMetadataResolver(this.casProperties.getAuthn().getSamlIdp().getMetadata().getCacheExpirationMinutes(), this.chainingMetadataResolverCacheLoader());
    }
}

