/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="samlIdPTicketCatalogConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPTicketCatalogConfiguration
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPTicketCatalogConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    public void configureTicketCatalog(TicketCatalog plan) {
        LOGGER.debug("Registering SAML2 protocol ticket definitions...");
        this.buildAndRegisterSamlArtifactDefinition(plan, this.buildTicketDefinition(plan, "SART", SamlArtifactTicketImpl.class));
        this.buildAndRegisterSamlAttributeQueryDefinition(plan, this.buildTicketDefinition(plan, "SATQ", SamlArtifactTicketImpl.class));
    }

    protected void buildAndRegisterSamlArtifactDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("samlArtifactsCache");
        metadata.getProperties().setStorageTimeout(this.casProperties.getTicket().getSt().getTimeToKillInSeconds());
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterSamlAttributeQueryDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("samlAttributeQueryCache");
        metadata.getProperties().setStorageTimeout(this.casProperties.getTicket().getSt().getTimeToKillInSeconds());
        this.registerTicketDefinition(plan, metadata);
    }
}

