/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URL;
import java.util.Map;
import lombok.Generated;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.metadata.generator.FileSystemSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.locator.FileSystemSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataResolver;
import org.apereo.cas.support.saml.idp.metadata.writer.DefaultSamlIdPCertificateAndKeyWriter;
import org.apereo.cas.support.saml.idp.metadata.writer.SamlIdPCertificateAndKeyWriter;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataHealthIndicator;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceDefaultCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataResolverCacheLoader;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.ClasspathResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.FileSystemResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.GroovyResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.JsonResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.MetadataQueryProtocolMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.UrlResourceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.DefaultSamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlanConfigurer;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.util.NonInflatingSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.metadata.SamlIdPMetadataController;
import org.apereo.cas.support.saml.web.idp.metadata.SamlRegisteredServiceCachedMetadataEndpoint;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPPostProfileHandlerEndpoint;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

@Configuration(value="samlIdPMetadataConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPMetadataConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataConfiguration.class);
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="noRedirectHttpClient")
    private ObjectProvider<HttpClient> httpClient;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> openSamlConfigBean;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="samlIdPServiceFactory")
    private ObjectProvider<ServiceFactory> samlIdPServiceFactory;
    @Autowired
    @Qualifier(value="samlProfileSamlResponseBuilder")
    private ObjectProvider<SamlProfileObjectBuilder<Response>> samlProfileSamlResponseBuilder;
    @Autowired
    @Qualifier(value="shibboleth.VelocityEngine")
    private ObjectProvider<VelocityEngine> velocityEngineFactoryBean;

    @Lazy
    @Bean(initMethod="initialize", destroyMethod="destroy")
    @DependsOn(value={"samlIdPMetadataGenerator"})
    public MetadataResolver casSamlIdPMetadataResolver() {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        SamlIdPMetadataResolver resolver = new SamlIdPMetadataResolver(this.samlIdPMetadataLocator(), this.samlIdPMetadataGenerator(), (OpenSamlConfigBean)this.openSamlConfigBean.getObject());
        resolver.setFailFastInitialization(idp.getMetadata().getCore().isFailFast());
        resolver.setRequireValidMetadata(idp.getMetadata().getCore().isRequireValidMetadata());
        resolver.setId(idp.getCore().getEntityId());
        return resolver;
    }

    @Lazy
    @Bean
    @RefreshScope
    public SamlIdPMetadataController samlIdPMetadataController() {
        return new SamlIdPMetadataController(this.samlIdPMetadataGenerator(), this.samlIdPMetadataLocator(), (ServicesManager)this.servicesManager.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject());
    }

    @ConditionalOnMissingBean(name={"samlIdPMetadataGenerator"})
    @Bean
    public SamlIdPMetadataGenerator samlIdPMetadataGenerator() {
        return new FileSystemSamlIdPMetadataGenerator(this.samlIdPMetadataGeneratorConfigurationContext());
    }

    @ConditionalOnMissingBean(name={"samlSelfSignedCertificateWriter"})
    @Bean
    public SamlIdPCertificateAndKeyWriter samlSelfSignedCertificateWriter() {
        URL url = new URL(this.casProperties.getServer().getPrefix());
        DefaultSamlIdPCertificateAndKeyWriter generator = new DefaultSamlIdPCertificateAndKeyWriter();
        generator.setHostname(url.getHost());
        generator.setUriSubjectAltNames(CollectionUtils.wrap((Object)url.getHost().concat("/idp/metadata")));
        return generator;
    }

    @ConditionalOnMissingBean(name={"samlIdPMetadataLocator"})
    @Bean
    public SamlIdPMetadataLocator samlIdPMetadataLocator() {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        String location = SpringExpressionLanguageValueResolver.getInstance().resolve(idp.getMetadata().getFileSystem().getLocation());
        AbstractResource metadataLocation = ResourceUtils.getRawResourceFrom((String)location);
        return new FileSystemSamlIdPMetadataLocator((Resource)metadataLocation, this.samlIdPMetadataCache());
    }

    @ConditionalOnMissingBean(name={"samlIdPMetadataCache"})
    @Bean
    @RefreshScope
    public Cache<String, SamlIdPMetadataDocument> samlIdPMetadataCache() {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        return Caffeine.newBuilder().initialCapacity(10).maximumSize(100L).expireAfterAccess(Beans.newDuration((String)idp.getMetadata().getCore().getCacheExpiration())).build();
    }

    @ConditionalOnMissingBean(name={"chainingMetadataResolverCacheLoader"})
    @Bean
    @RefreshScope
    public SamlRegisteredServiceMetadataResolverCacheLoader chainingMetadataResolverCacheLoader() {
        return new SamlRegisteredServiceMetadataResolverCacheLoader((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), (HttpClient)this.httpClient.getObject(), this.samlRegisteredServiceMetadataResolvers());
    }

    @ConditionalOnMissingBean(name={"samlRegisteredServiceMetadataResolvers"})
    @Bean
    public SamlRegisteredServiceMetadataResolutionPlan samlRegisteredServiceMetadataResolvers() {
        DefaultSamlRegisteredServiceMetadataResolutionPlan plan = new DefaultSamlRegisteredServiceMetadataResolutionPlan();
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        OpenSamlConfigBean cfgBean = (OpenSamlConfigBean)this.openSamlConfigBean.getObject();
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new MetadataQueryProtocolMetadataResolver(samlIdp, cfgBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new JsonResourceMetadataResolver(samlIdp, cfgBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new FileSystemResourceMetadataResolver(samlIdp, cfgBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new UrlResourceMetadataResolver(samlIdp, cfgBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new ClasspathResourceMetadataResolver(samlIdp, cfgBean));
        plan.registerMetadataResolver((SamlRegisteredServiceMetadataResolver)new GroovyResourceMetadataResolver(samlIdp, cfgBean));
        Map configurers = this.applicationContext.getBeansOfType(SamlRegisteredServiceMetadataResolutionPlanConfigurer.class, false, true);
        configurers.values().forEach(c -> {
            LOGGER.trace("Configuring saml metadata resolution plan [{}]", (Object)c.getName());
            c.configureMetadataResolutionPlan((SamlRegisteredServiceMetadataResolutionPlan)plan);
        });
        return plan;
    }

    @ConditionalOnMissingBean(name={"defaultSamlRegisteredServiceCachingMetadataResolver"})
    @Bean
    @RefreshScope
    public SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver() {
        return new SamlRegisteredServiceDefaultCachingMetadataResolver(Beans.newDuration((String)this.casProperties.getAuthn().getSamlIdp().getMetadata().getCore().getCacheExpiration()), this.chainingMetadataResolverCacheLoader(), (OpenSamlConfigBean)this.openSamlConfigBean.getObject());
    }

    @ConditionalOnMissingBean(name={"samlRegisteredServiceMetadataHealthIndicator"})
    @Bean
    @ConditionalOnEnabledHealthIndicator(value="samlRegisteredServiceMetadataHealthIndicator")
    public HealthIndicator samlRegisteredServiceMetadataHealthIndicator() {
        return new SamlRegisteredServiceMetadataHealthIndicator(this.samlRegisteredServiceMetadataResolvers(), (ServicesManager)this.servicesManager.getObject());
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public SamlRegisteredServiceCachedMetadataEndpoint samlRegisteredServiceCachedMetadataEndpoint() {
        return new SamlRegisteredServiceCachedMetadataEndpoint(this.casProperties, this.defaultSamlRegisteredServiceCachingMetadataResolver(), (ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (OpenSamlConfigBean)this.openSamlConfigBean.getObject());
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public SSOSamlIdPPostProfileHandlerEndpoint ssoSamlPostProfileHandlerEndpoint() {
        return new SSOSamlIdPPostProfileHandlerEndpoint(this.casProperties, (ServicesManager)this.servicesManager.getObject(), (AuthenticationSystemSupport)this.authenticationSystemSupport.getObject(), (ServiceFactory)this.samlIdPServiceFactory.getObject(), PrincipalFactoryUtils.newPrincipalFactory(), (SamlProfileObjectBuilder)this.samlProfileSamlResponseBuilder.getObject(), this.defaultSamlRegisteredServiceCachingMetadataResolver(), (AbstractSaml20ObjectBuilder)new NonInflatingSaml20ObjectBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject()));
    }

    @Bean
    @ConditionalOnMissingBean(name={"samlIdPMetadataGeneratorCipherExecutor"})
    public CipherExecutor samlIdPMetadataGeneratorCipherExecutor() {
        return CipherExecutor.noOpOfStringToString();
    }

    @Bean
    @ConditionalOnMissingBean(name={"samlIdPMetadataGeneratorConfigurationContext"})
    public SamlIdPMetadataGeneratorConfigurationContext samlIdPMetadataGeneratorConfigurationContext() {
        return SamlIdPMetadataGeneratorConfigurationContext.builder().samlIdPMetadataLocator(this.samlIdPMetadataLocator()).samlIdPCertificateAndKeyWriter(this.samlSelfSignedCertificateWriter()).applicationContext(this.applicationContext).metadataCipherExecutor(this.samlIdPMetadataGeneratorCipherExecutor()).casProperties(this.casProperties).openSamlConfigBean((OpenSamlConfigBean)this.openSamlConfigBean.getObject()).velocityEngine((VelocityEngine)this.velocityEngineFactoryBean.getObject()).build();
    }
}

