/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.time.Duration;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilderConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.audit.SamlRequestAuditResourceResolver;
import org.apereo.cas.support.saml.web.idp.audit.SamlResponseAuditPrincipalIdProvider;
import org.apereo.cas.support.saml.web.idp.audit.SamlResponseAuditResourceResolver;
import org.apereo.cas.support.saml.web.idp.profile.artifact.CasSamlArtifactMap;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.assertion.SamlProfileSamlAssertionBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlProfileSamlAttributeStatementBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.AuthnContextClassRefBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.DefaultAuthnContextClassRefBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.SamlProfileSamlAuthNStatementBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.conditions.SamlProfileSamlConditionsBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.DefaultSamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.nameid.SamlProfileSamlNameIdBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSaml2ResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.artifact.SamlProfileArtifactFaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.artifact.SamlProfileArtifactResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.query.SamlProfileAttributeQueryFaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.query.SamlProfileAttributeQueryResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11FaultResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11ResponseBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.subject.SamlProfileSamlSubjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.artifact.DefaultSamlArtifactTicketFactory;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.query.DefaultSamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.ecp.Response;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="samlIdPConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPConfiguration {
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="samlIdPDistributedSessionStore")
    private ObjectProvider<SessionStore> samlIdPDistributedSessionStore;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver")
    private ObjectProvider<SamlRegisteredServiceCachingMetadataResolver> defaultSamlRegisteredServiceCachingMetadataResolver;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="casSamlIdPMetadataResolver")
    private ObjectProvider<MetadataResolver> casSamlIdPMetadataResolver;
    @Autowired
    @Qualifier(value="shibbolethCompatiblePersistentIdGenerator")
    private ObjectProvider<PersistentIdGenerator> shibbolethCompatiblePersistentIdGenerator;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> openSamlConfigBean;
    @Autowired
    @Qualifier(value="shibboleth.VelocityEngine")
    private ObjectProvider<VelocityEngine> velocityEngineFactory;
    @Autowired
    @Qualifier(value="samlIdPServiceFactory")
    private ObjectProvider<ServiceFactory> samlIdPServiceFactory;
    @Autowired
    @Qualifier(value="samlIdPMetadataLocator")
    private ObjectProvider<SamlIdPMetadataLocator> samlIdPMetadataLocator;
    @Autowired
    @Qualifier(value="attributeDefinitionStore")
    private ObjectProvider<AttributeDefinitionStore> attributeDefinitionStore;
    @Autowired
    @Qualifier(value="urlValidator")
    private ObjectProvider<UrlValidator> urlValidator;

    @ConditionalOnMissingBean(name={"samlSingleLogoutServiceLogoutUrlBuilder"})
    @Bean
    @RefreshScope
    public SingleLogoutServiceLogoutUrlBuilder samlSingleLogoutServiceLogoutUrlBuilder() {
        return new SamlIdPSingleLogoutServiceLogoutUrlBuilder((ServicesManager)this.servicesManager.getObject(), (SamlRegisteredServiceCachingMetadataResolver)this.defaultSamlRegisteredServiceCachingMetadataResolver.getObject(), (UrlValidator)this.urlValidator.getObject());
    }

    @ConditionalOnMissingBean(name={"samlSingleLogoutServiceLogoutUrlBuilderConfigurer"})
    @Bean
    @RefreshScope
    public SingleLogoutServiceLogoutUrlBuilderConfigurer samlSingleLogoutServiceLogoutUrlBuilderConfigurer() {
        return this::samlSingleLogoutServiceLogoutUrlBuilder;
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlResponseBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlResponseBuilder() {
        return new SamlProfileSaml2ResponseBuilder(this.getSamlResponseBuilderConfigurationContextBuilder().build());
    }

    @ConditionalOnMissingBean(name={"samlArtifactTicketFactory"})
    @Bean
    @RefreshScope
    public SamlArtifactTicketFactory samlArtifactTicketFactory() {
        return new DefaultSamlArtifactTicketFactory(this.samlArtifactTicketExpirationPolicy(), (OpenSamlConfigBean)this.openSamlConfigBean.getObject(), (ServiceFactory)this.samlIdPServiceFactory.getObject());
    }

    @ConditionalOnMissingBean(name={"samlArtifactTicketFactoryConfigurer"})
    @Bean
    @RefreshScope
    public TicketFactoryExecutionPlanConfigurer samlArtifactTicketFactoryConfigurer() {
        return this::samlArtifactTicketFactory;
    }

    @ConditionalOnMissingBean(name={"samlArtifactTicketExpirationPolicy"})
    @Bean
    @RefreshScope
    public ExpirationPolicyBuilder samlArtifactTicketExpirationPolicy() {
        return new SamlArtifactTicketExpirationPolicyBuilder(this.casProperties);
    }

    @Bean(initMethod="initialize", destroyMethod="destroy")
    @RefreshScope
    public SAMLArtifactMap samlArtifactMap() {
        CasSamlArtifactMap map = new CasSamlArtifactMap((TicketRegistry)this.ticketRegistry.getObject(), this.samlArtifactTicketFactory(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (SessionStore)this.samlIdPDistributedSessionStore.getObject(), (CentralAuthenticationService)this.centralAuthenticationService.getObject());
        ExpirationPolicy expirationPolicy = this.samlArtifactTicketExpirationPolicy().buildTicketExpirationPolicy();
        map.setArtifactLifetime(Duration.ofSeconds(expirationPolicy.getTimeToLive()));
        return map;
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlSubjectBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder() {
        return new SamlProfileSamlSubjectBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), this.samlProfileSamlNameIdBuilder(), this.casProperties, this.samlObjectEncrypter());
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlSoap11FaultResponseBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<Response> samlProfileSamlSoap11FaultResponseBuilder() {
        SamlProfileSamlResponseBuilderConfigurationContext context = this.getSamlResponseBuilderConfigurationContextBuilder().samlSoapResponseBuilder(this.samlProfileSamlResponseBuilder()).build();
        return new SamlProfileSamlSoap11FaultResponseBuilder(context);
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlSoap11ResponseBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<Response> samlProfileSamlSoap11ResponseBuilder() {
        SamlProfileSamlResponseBuilderConfigurationContext context = this.getSamlResponseBuilderConfigurationContextBuilder().samlSoapResponseBuilder(this.samlProfileSamlResponseBuilder()).build();
        return new SamlProfileSamlSoap11ResponseBuilder(context);
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlArtifactFaultResponseBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlArtifactFaultResponseBuilder() {
        SamlProfileSamlResponseBuilderConfigurationContext context = this.getSamlResponseBuilderConfigurationContextBuilder().samlSoapResponseBuilder(this.samlProfileSamlResponseBuilder()).build();
        return new SamlProfileArtifactFaultResponseBuilder(context);
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlArtifactResponseBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlArtifactResponseBuilder() {
        SamlProfileSamlResponseBuilderConfigurationContext context = this.getSamlResponseBuilderConfigurationContextBuilder().samlSoapResponseBuilder(this.samlProfileSamlResponseBuilder()).build();
        return new SamlProfileArtifactResponseBuilder(context);
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlNameIdBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<NameID> samlProfileSamlNameIdBuilder() {
        return new SamlProfileSamlNameIdBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), (PersistentIdGenerator)this.shibbolethCompatiblePersistentIdGenerator.getObject());
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlConditionsBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder() {
        return new SamlProfileSamlConditionsBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"defaultAuthnContextClassRefBuilder"})
    @Bean
    @RefreshScope
    public AuthnContextClassRefBuilder defaultAuthnContextClassRefBuilder() {
        return new DefaultAuthnContextClassRefBuilder(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlAssertionBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder() {
        return new SamlProfileSamlAssertionBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), this.samlProfileSamlAuthNStatementBuilder(), this.samlProfileSamlAttributeStatementBuilder(), this.samlProfileSamlSubjectBuilder(), this.samlProfileSamlConditionsBuilder(), this.samlObjectSigner(), (MetadataResolver)this.casSamlIdPMetadataResolver.getObject());
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlAuthNStatementBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder() {
        return new SamlProfileSamlAuthNStatementBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), this.defaultAuthnContextClassRefBuilder(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlAttributeStatementBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder() {
        return new SamlProfileSamlAttributeStatementBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), this.casProperties.getAuthn().getSamlIdp(), this.samlObjectEncrypter(), (AttributeDefinitionStore)this.attributeDefinitionStore.getObject(), (ServiceFactory)this.samlIdPServiceFactory.getObject());
    }

    @ConditionalOnMissingBean(name={"samlObjectEncrypter"})
    @Bean
    @RefreshScope
    public SamlIdPObjectEncrypter samlObjectEncrypter() {
        return new SamlIdPObjectEncrypter(this.casProperties.getAuthn().getSamlIdp());
    }

    @ConditionalOnMissingBean(name={"samlObjectSigner"})
    @Bean
    @RefreshScope
    public SamlIdPObjectSigner samlObjectSigner() {
        return new DefaultSamlIdPObjectSigner((MetadataResolver)this.casSamlIdPMetadataResolver.getObject(), this.casProperties, (SamlIdPMetadataLocator)this.samlIdPMetadataLocator.getObject());
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlAttributeQueryFaultResponseBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlAttributeQueryFaultResponseBuilder() {
        SamlProfileSamlResponseBuilderConfigurationContext context = this.getSamlResponseBuilderConfigurationContextBuilder().samlSoapResponseBuilder(this.samlProfileSamlResponseBuilder()).build();
        return new SamlProfileAttributeQueryFaultResponseBuilder(context);
    }

    @ConditionalOnMissingBean(name={"samlProfileSamlAttributeQueryResponseBuilder"})
    @Bean
    @RefreshScope
    public SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response> samlProfileSamlAttributeQueryResponseBuilder() {
        SamlProfileSamlResponseBuilderConfigurationContext context = this.getSamlResponseBuilderConfigurationContextBuilder().samlSoapResponseBuilder(this.samlProfileSamlResponseBuilder()).build();
        return new SamlProfileAttributeQueryResponseBuilder(context);
    }

    @ConditionalOnMissingBean(name={"samlAttributeQueryTicketFactory"})
    @Bean
    @RefreshScope
    public SamlAttributeQueryTicketFactory samlAttributeQueryTicketFactory() {
        return new DefaultSamlAttributeQueryTicketFactory(this.samlAttributeQueryTicketExpirationPolicy(), (ServiceFactory)this.samlIdPServiceFactory.getObject(), (OpenSamlConfigBean)this.openSamlConfigBean.getObject());
    }

    @ConditionalOnMissingBean(name={"samlAttributeQueryTicketFactoryConfigurer"})
    @Bean
    @RefreshScope
    public TicketFactoryExecutionPlanConfigurer samlAttributeQueryTicketFactoryConfigurer() {
        return this::samlAttributeQueryTicketFactory;
    }

    @ConditionalOnMissingBean(name={"samlAttributeQueryTicketExpirationPolicy"})
    @Bean
    @RefreshScope
    public ExpirationPolicyBuilder samlAttributeQueryTicketExpirationPolicy() {
        return new SamlAttributeQueryTicketExpirationPolicyBuilder(this.casProperties);
    }

    @Bean
    public SamlResponseAuditPrincipalIdProvider samlResponseAuditPrincipalIdProvider() {
        return new SamlResponseAuditPrincipalIdProvider();
    }

    @Bean
    @ConditionalOnMissingBean(name={"casSamlIdPAuditTrailRecordResolutionPlanConfigurer"})
    public AuditTrailRecordResolutionPlanConfigurer casSamlIdPAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditResourceResolver("SAML2_RESPONSE_RESOURCE_RESOLVER", (AuditResourceResolver)new SamlResponseAuditResourceResolver());
            plan.registerAuditActionResolver("SAML2_RESPONSE_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
            plan.registerAuditResourceResolver("SAML2_REQUEST_RESOURCE_RESOLVER", (AuditResourceResolver)new SamlRequestAuditResourceResolver());
            plan.registerAuditActionResolver("SAML2_REQUEST_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
        };
    }

    private SamlProfileSamlResponseBuilderConfigurationContext.SamlProfileSamlResponseBuilderConfigurationContextBuilder getSamlResponseBuilderConfigurationContextBuilder() {
        return SamlProfileSamlResponseBuilderConfigurationContext.builder().samlIdPMetadataResolver((MetadataResolver)this.casSamlIdPMetadataResolver.getObject()).openSamlConfigBean((OpenSamlConfigBean)this.openSamlConfigBean.getObject()).samlObjectSigner(this.samlObjectSigner()).velocityEngineFactory((VelocityEngine)this.velocityEngineFactory.getObject()).samlProfileSamlAssertionBuilder(this.samlProfileSamlAssertionBuilder()).samlObjectEncrypter(this.samlObjectEncrypter()).ticketGrantingTicketCookieGenerator((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject()).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).sessionStore((SessionStore)this.samlIdPDistributedSessionStore.getObject()).samlArtifactTicketFactory(this.samlArtifactTicketFactory()).samlArtifactMap(this.samlArtifactMap()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).samlAttributeQueryTicketFactory(this.samlAttributeQueryTicketFactory()).casProperties(this.casProperties);
    }
}

