/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPAlgorithmsProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPCoreProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProfileProperties;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.LogoutRedirectionStrategy;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.pac4j.BrowserWebStorageSessionStore;
import org.apereo.cas.pac4j.DistributedJEESessionStore;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlIdPServiceRegistry;
import org.apereo.cas.support.saml.services.SamlIdPServicesManagerRegisteredServiceLocator;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.HttpServletRequestXMLMessageDecodersMap;
import org.apereo.cas.support.saml.web.idp.profile.SamlIdPInitiatedProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.artifact.SamlIdPSaml1ArtifactResolutionProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.validate.SamlIdPObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.validate.SamlObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.ecp.ECPSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.query.SamlIdPSaml2AttributeQueryProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SLOSamlIdPPostProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SLOSamlIdPRedirectProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPLogoutResponseObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPProfileSingleLogoutMessageCreator;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPSingleLogoutRedirectionStrategy;
import org.apereo.cas.support.saml.web.idp.profile.slo.SamlIdPSingleLogoutServiceMessageHandler;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPPostProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPPostSimpleSignProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.SSOSamlIdPProfileCallbackHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.sso.UrlDecodingHTTPRedirectDeflateDecoder;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.DefaultSSOSamlHttpRequestExtractor;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.SSOSamlHttpRequestExtractor;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.InternalTicketValidator;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.CookieUtils;
import org.jasig.cas.client.validation.TicketValidator;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostSimpleSignDecoder;
import org.opensaml.saml.saml2.ecp.Response;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;

@Configuration(value="samlIdPEndpointsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPEndpointsConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPEndpointsConfiguration.class);
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="singleSignOnParticipationStrategy")
    private ObjectProvider<SingleSignOnParticipationStrategy> singleSignOnParticipationStrategy;
    @Autowired
    @Qualifier(value="webflowCipherExecutor")
    private ObjectProvider<CipherExecutor> webflowCipherExecutor;
    @Autowired
    @Qualifier(value="singleLogoutServiceLogoutUrlBuilder")
    private ObjectProvider<SingleLogoutServiceLogoutUrlBuilder> singleLogoutServiceLogoutUrlBuilder;
    @Autowired
    @Qualifier(value="noRedirectHttpClient")
    private ObjectProvider<HttpClient> httpClient;
    @Autowired
    @Qualifier(value="shibboleth.VelocityEngine")
    private ObjectProvider<VelocityEngine> velocityEngineFactory;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> openSamlConfigBean;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private ObjectProvider<TicketFactory> ticketFactory;
    @Autowired
    @Qualifier(value="samlProfileSamlResponseBuilder")
    private ObjectProvider<SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response>> samlProfileSamlResponseBuilder;
    @Autowired
    @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver")
    private ObjectProvider<SamlRegisteredServiceCachingMetadataResolver> defaultSamlRegisteredServiceCachingMetadataResolver;
    @Autowired
    @Qualifier(value="samlIdPServiceFactory")
    private ObjectProvider<ServiceFactory> samlIdPServiceFactory;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="samlObjectSigner")
    private ObjectProvider<SamlIdPObjectSigner> samlObjectSigner;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="casSamlIdPMetadataResolver")
    private ObjectProvider<MetadataResolver> casSamlIdPMetadataResolver;
    @Autowired
    @Qualifier(value="samlProfileSamlSoap11ResponseBuilder")
    private ObjectProvider<SamlProfileObjectBuilder<Response>> samlProfileSamlSoap11ResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlSoap11FaultResponseBuilder")
    private ObjectProvider<SamlProfileObjectBuilder<Response>> samlProfileSamlSoap11FaultResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlArtifactResponseBuilder")
    private ObjectProvider<SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response>> samlProfileSamlArtifactResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlArtifactFaultResponseBuilder")
    private ObjectProvider<SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response>> samlProfileSamlArtifactFaultResponseBuilder;
    @Autowired
    @Qualifier(value="authenticationAttributeReleasePolicy")
    private ObjectProvider<AuthenticationAttributeReleasePolicy> authenticationAttributeReleasePolicy;
    @Autowired
    @Qualifier(value="samlProfileSamlAttributeQueryResponseBuilder")
    private ObjectProvider<SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response>> samlProfileSamlAttributeQueryResponseBuilder;
    @Autowired
    @Qualifier(value="samlProfileSamlAttributeQueryFaultResponseBuilder")
    private ObjectProvider<SamlProfileObjectBuilder<org.opensaml.saml.saml2.core.Response>> samlProfileSamlAttributeQueryFaultResponseBuilder;
    @Autowired
    @Qualifier(value="samlAttributeQueryTicketFactory")
    private ObjectProvider<SamlAttributeQueryTicketFactory> samlAttributeQueryTicketFactory;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="samlArtifactTicketFactory")
    private ObjectProvider<SamlArtifactTicketFactory> samlArtifactTicketFactory;

    @ConditionalOnMissingBean(name={"samlIdPObjectSignatureValidator"})
    @Bean
    public SamlObjectSignatureValidator samlIdPObjectSignatureValidator() {
        SamlIdPAlgorithmsProperties algs = this.casProperties.getAuthn().getSamlIdp().getAlgs();
        return new SamlIdPObjectSignatureValidator(algs.getOverrideSignatureReferenceDigestMethods(), algs.getOverrideSignatureAlgorithms(), algs.getOverrideBlockedSignatureSigningAlgorithms(), algs.getOverrideAllowedSignatureSigningAlgorithms(), (MetadataResolver)this.casSamlIdPMetadataResolver.getObject(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"samlObjectSignatureValidator"})
    @Bean
    public SamlObjectSignatureValidator samlObjectSignatureValidator() {
        SamlIdPAlgorithmsProperties algs = this.casProperties.getAuthn().getSamlIdp().getAlgs();
        return new SamlObjectSignatureValidator(algs.getOverrideSignatureReferenceDigestMethods(), algs.getOverrideSignatureAlgorithms(), algs.getOverrideBlockedSignatureSigningAlgorithms(), algs.getOverrideAllowedSignatureSigningAlgorithms(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"ssoSamlHttpRequestExtractor"})
    @Bean
    public SSOSamlHttpRequestExtractor ssoSamlHttpRequestExtractor() {
        return new DefaultSSOSamlHttpRequestExtractor(((OpenSamlConfigBean)this.openSamlConfigBean.getObject()).getParserPool());
    }

    @Bean
    @ConditionalOnMissingBean(name={"ssoPostProfileHandlerDecoders"})
    public HttpServletRequestXMLMessageDecodersMap ssoPostProfileHandlerDecoders() {
        SamlIdPProfileProperties.Saml2SsoProfile props = this.casProperties.getAuthn().getSamlIdp().getProfile().getSso();
        HttpServletRequestXMLMessageDecodersMap decoders = new HttpServletRequestXMLMessageDecodersMap(HttpMethod.class);
        decoders.put((Enum)HttpMethod.GET, (Object)new UrlDecodingHTTPRedirectDeflateDecoder(props.isUrlDecodeRedirectRequest()));
        decoders.put((Enum)HttpMethod.POST, (Object)new HTTPPostDecoder());
        return decoders;
    }

    @Bean
    @RefreshScope
    public SSOSamlIdPPostProfileHandlerController ssoPostProfileHandlerController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().responseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlResponseBuilder.getObject()).samlMessageDecoders(this.ssoPostProfileHandlerDecoders()).build();
        return new SSOSamlIdPPostProfileHandlerController(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"ssoPostSimpleSignProfileHandlerDecoders"})
    public HttpServletRequestXMLMessageDecodersMap ssoPostSimpleSignProfileHandlerDecoders() {
        SamlIdPProfileProperties.Saml2SsoPostSimpleSignProfile props = this.casProperties.getAuthn().getSamlIdp().getProfile().getSsoPostSimpleSign();
        HttpServletRequestXMLMessageDecodersMap decoders = new HttpServletRequestXMLMessageDecodersMap(HttpMethod.class);
        decoders.put((Enum)HttpMethod.GET, (Object)new UrlDecodingHTTPRedirectDeflateDecoder(props.isUrlDecodeRedirectRequest()));
        decoders.put((Enum)HttpMethod.POST, (Object)new HTTPPostSimpleSignDecoder());
        return decoders;
    }

    @Bean
    @RefreshScope
    public SSOSamlIdPPostSimpleSignProfileHandlerController ssoPostSimpleSignProfileHandlerController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().responseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlResponseBuilder.getObject()).samlMessageDecoders(this.ssoPostSimpleSignProfileHandlerDecoders()).build();
        return new SSOSamlIdPPostSimpleSignProfileHandlerController(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"sloRedirectProfileHandlerDecoders"})
    public HttpServletRequestXMLMessageDecodersMap sloRedirectProfileHandlerDecoders() {
        SamlIdPProfileProperties.Saml2SloProfile props = this.casProperties.getAuthn().getSamlIdp().getProfile().getSlo();
        HttpServletRequestXMLMessageDecodersMap decoders = new HttpServletRequestXMLMessageDecodersMap(HttpMethod.class);
        decoders.put((Enum)HttpMethod.GET, (Object)new UrlDecodingHTTPRedirectDeflateDecoder(props.isUrlDecodeRedirectRequest()));
        return decoders;
    }

    @Bean
    @RefreshScope
    public SLOSamlIdPRedirectProfileHandlerController sloRedirectProfileHandlerController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().samlMessageDecoders(this.sloRedirectProfileHandlerDecoders()).build();
        return new SLOSamlIdPRedirectProfileHandlerController(context);
    }

    @Bean
    @ConditionalOnMissingBean(name={"sloPostProfileHandlerDecoders"})
    public HttpServletRequestXMLMessageDecodersMap sloPostProfileHandlerDecoders() {
        HttpServletRequestXMLMessageDecodersMap decoders = new HttpServletRequestXMLMessageDecodersMap(HttpMethod.class);
        decoders.put((Enum)HttpMethod.POST, (Object)new HTTPPostDecoder());
        return decoders;
    }

    @Bean
    @RefreshScope
    public SLOSamlIdPPostProfileHandlerController sloPostProfileHandlerController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().samlMessageDecoders(this.sloPostProfileHandlerDecoders()).build();
        return new SLOSamlIdPPostProfileHandlerController(context);
    }

    @Bean
    @RefreshScope
    public SamlIdPInitiatedProfileHandlerController idpInitiatedSamlProfileHandlerController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().samlObjectSignatureValidator(this.samlIdPObjectSignatureValidator()).build();
        return new SamlIdPInitiatedProfileHandlerController(context);
    }

    @Bean
    @RefreshScope
    public SSOSamlIdPProfileCallbackHandlerController ssoPostProfileCallbackHandlerController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().build();
        return new SSOSamlIdPProfileCallbackHandlerController(context);
    }

    @Bean
    @RefreshScope
    public ECPSamlIdPProfileHandlerController ecpProfileHandlerController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().responseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlSoap11ResponseBuilder.getObject()).samlFaultResponseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlSoap11FaultResponseBuilder.getObject()).build();
        return new ECPSamlIdPProfileHandlerController(context);
    }

    @Bean
    @RefreshScope
    public SamlIdPSaml1ArtifactResolutionProfileHandlerController saml1ArtifactResolutionController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().responseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlArtifactResponseBuilder.getObject()).samlFaultResponseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlArtifactFaultResponseBuilder.getObject()).build();
        return new SamlIdPSaml1ArtifactResolutionProfileHandlerController(context);
    }

    @ConditionalOnProperty(prefix="cas.authn.saml-idp.core", name={"attribute-query-profile-enabled"}, havingValue="true")
    @Bean
    @RefreshScope
    public SamlIdPSaml2AttributeQueryProfileHandlerController saml2AttributeQueryProfileHandlerController() {
        SamlProfileHandlerConfigurationContext context = this.getSamlProfileHandlerConfigurationContextBuilder().responseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlAttributeQueryResponseBuilder.getObject()).samlFaultResponseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlAttributeQueryFaultResponseBuilder.getObject()).build();
        return new SamlIdPSaml2AttributeQueryProfileHandlerController(context);
    }

    @Bean
    public Service samlIdPCallbackService() {
        String service = this.casProperties.getServer().getPrefix().concat("/idp/profile/SAML2/Callback");
        return ((ServiceFactory)this.samlIdPServiceFactory.getObject()).createService(service);
    }

    @Bean
    @ConditionalOnMissingBean(name={"samlIdPServiceRegistryExecutionPlanConfigurer"})
    public ServiceRegistryExecutionPlanConfigurer samlIdPServiceRegistryExecutionPlanConfigurer() {
        return plan -> {
            String callbackService = this.samlIdPCallbackService().getId().concat(".*");
            LOGGER.debug("Initializing SAML IdP callback service [{}]", (Object)callbackService);
            RegexRegisteredService service = new RegexRegisteredService();
            service.setId(RandomUtils.nextLong());
            service.setEvaluationOrder(Integer.MIN_VALUE);
            service.setName(service.getClass().getSimpleName());
            service.setDescription("SAML Authentication Request Callback");
            service.setServiceId(callbackService);
            plan.registerServiceRegistry((ServiceRegistry)new SamlIdPServiceRegistry(this.applicationContext, new RegisteredService[]{service}));
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"samlIdPServicesManagerRegisteredServiceLocator"})
    public ServicesManagerRegisteredServiceLocator samlIdPServicesManagerRegisteredServiceLocator() {
        return new SamlIdPServicesManagerRegisteredServiceLocator((SamlRegisteredServiceCachingMetadataResolver)this.defaultSamlRegisteredServiceCachingMetadataResolver.getObject());
    }

    @ConditionalOnMissingBean(name={"samlIdPDistributedSessionCookieGenerator"})
    @Bean
    @RefreshScope
    public CasCookieBuilder samlIdPDistributedSessionCookieGenerator() {
        CookieSessionReplicationProperties cookie = this.casProperties.getSessionReplication().getCookie();
        return CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
    }

    @ConditionalOnMissingBean(name={"samlIdPDistributedSessionStore"})
    @Bean
    @RefreshScope
    public SessionStore samlIdPDistributedSessionStore() {
        SamlIdPCoreProperties.SessionStorageTypes type = this.casProperties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SamlIdPCoreProperties.SessionStorageTypes.TICKET_REGISTRY) {
            return new DistributedJEESessionStore((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (TicketFactory)this.ticketFactory.getObject(), this.samlIdPDistributedSessionCookieGenerator());
        }
        if (type == SamlIdPCoreProperties.SessionStorageTypes.BROWSER_SESSION_STORAGE) {
            return new BrowserWebStorageSessionStore((CipherExecutor)this.webflowCipherExecutor.getObject());
        }
        return JEESessionStore.INSTANCE;
    }

    @ConditionalOnMissingBean(name={"samlIdPSingleLogoutRedirectionStrategy"})
    @Bean
    @RefreshScope
    public LogoutRedirectionStrategy samlIdPSingleLogoutRedirectionStrategy() {
        return new SamlIdPSingleLogoutRedirectionStrategy(this.getSamlProfileHandlerConfigurationContextBuilder().build());
    }

    @Bean
    @ConditionalOnMissingBean(name={"samlIdPTicketValidator"})
    public TicketValidator samlIdPTicketValidator() {
        return new InternalTicketValidator((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (ServiceFactory)this.samlIdPServiceFactory.getObject(), (AuthenticationAttributeReleasePolicy)this.authenticationAttributeReleasePolicy.getObject(), (ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"samlLogoutBuilder"})
    @Bean
    @RefreshScope
    public SingleLogoutMessageCreator samlLogoutBuilder() {
        return new SamlIdPProfileSingleLogoutMessageCreator((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), (ServicesManager)this.servicesManager.getObject(), (SamlRegisteredServiceCachingMetadataResolver)this.defaultSamlRegisteredServiceCachingMetadataResolver.getObject(), this.casProperties.getAuthn().getSamlIdp(), (SamlIdPObjectSigner)this.samlObjectSigner.getObject());
    }

    @ConditionalOnMissingBean(name={"samlSingleLogoutServiceMessageHandler"})
    @Bean
    public SingleLogoutServiceMessageHandler samlSingleLogoutServiceMessageHandler() {
        return new SamlIdPSingleLogoutServiceMessageHandler((HttpClient)this.httpClient.getObject(), this.samlLogoutBuilder(), (ServicesManager)this.servicesManager.getObject(), (SingleLogoutServiceLogoutUrlBuilder)this.singleLogoutServiceLogoutUrlBuilder.getObject(), this.casProperties.getSlo().isAsynchronous(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject(), (SamlRegisteredServiceCachingMetadataResolver)this.defaultSamlRegisteredServiceCachingMetadataResolver.getObject(), (VelocityEngine)this.velocityEngineFactory.getObject(), (OpenSamlConfigBean)this.openSamlConfigBean.getObject());
    }

    @ConditionalOnMissingBean(name={"casSamlIdPLogoutExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public LogoutExecutionPlanConfigurer casSamlIdPLogoutExecutionPlanConfigurer() {
        return plan -> {
            plan.registerLogoutRedirectionStrategy(this.samlIdPSingleLogoutRedirectionStrategy());
            plan.registerSingleLogoutServiceMessageHandler(this.samlSingleLogoutServiceMessageHandler());
        };
    }

    @Bean
    public SamlIdPLogoutResponseObjectBuilder samlIdPLogoutResponseObjectBuilder() {
        return new SamlIdPLogoutResponseObjectBuilder((OpenSamlConfigBean)this.openSamlConfigBean.getObject());
    }

    @Bean
    public ProtocolEndpointWebSecurityConfigurer<Void> samlIdPProtocolEndpointConfigurer() {
        return new ProtocolEndpointWebSecurityConfigurer<Void>(){

            public List<String> getIgnoredEndpoints() {
                return List.of(StringUtils.prependIfMissing((String)"/idp/profile/SAML1", (CharSequence)"/", (CharSequence[])new CharSequence[0]), StringUtils.prependIfMissing((String)"/idp/profile/SAML2", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
            }
        };
    }

    private SamlProfileHandlerConfigurationContext.SamlProfileHandlerConfigurationContextBuilder getSamlProfileHandlerConfigurationContextBuilder() {
        return SamlProfileHandlerConfigurationContext.builder().samlObjectSigner((SamlIdPObjectSigner)this.samlObjectSigner.getObject()).authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).webApplicationServiceFactory((ServiceFactory)this.samlIdPServiceFactory.getObject()).samlRegisteredServiceCachingMetadataResolver((SamlRegisteredServiceCachingMetadataResolver)this.defaultSamlRegisteredServiceCachingMetadataResolver.getObject()).openSamlConfigBean((OpenSamlConfigBean)this.openSamlConfigBean.getObject()).casProperties(this.casProperties).ticketRegistrySupport((TicketRegistrySupport)this.ticketRegistrySupport.getObject()).singleSignOnParticipationStrategy((SingleSignOnParticipationStrategy)this.singleSignOnParticipationStrategy.getObject()).logoutResponseBuilder(this.samlIdPLogoutResponseObjectBuilder()).singleLogoutServiceLogoutUrlBuilder((SingleLogoutServiceLogoutUrlBuilder)this.singleLogoutServiceLogoutUrlBuilder.getObject()).artifactTicketFactory((SamlArtifactTicketFactory)this.samlArtifactTicketFactory.getObject()).samlObjectSignatureValidator(this.samlObjectSignatureValidator()).samlHttpRequestExtractor(this.ssoSamlHttpRequestExtractor()).responseBuilder((SamlProfileObjectBuilder)this.samlProfileSamlResponseBuilder.getObject()).ticketValidator(this.samlIdPTicketValidator()).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).sessionStore(this.samlIdPDistributedSessionStore()).ticketGrantingTicketCookieGenerator((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject()).samlAttributeQueryTicketFactory((SamlAttributeQueryTicketFactory)this.samlAttributeQueryTicketFactory.getObject()).samlDistributedSessionCookieGenerator(this.samlIdPDistributedSessionCookieGenerator()).callbackService(this.samlIdPCallbackService());
    }
}

