/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Map;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.authentication.SamlIdPServiceFactory;
import org.apereo.cas.support.saml.services.SamlIdPEntityIdAuthenticationServiceSelectionStrategy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperCustomizer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SAMLIdentityProvider})
@AutoConfiguration
public class SamlIdPAuthenticationServiceSelectionStrategyConfiguration {

    @Configuration(value="SamlIdPAuthenticationServiceFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPAuthenticationServiceFactoryConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"samlIdPServiceFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceFactory samlIdPServiceFactory() {
            return new SamlIdPServiceFactory();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceFactoryConfigurer samlIdPServiceFactoryConfigurer(@Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory) {
            return () -> CollectionUtils.wrap((Object)samlIdPServiceFactory);
        }
    }

    @Configuration(value="SamlIdPAuthenticationServiceSelectionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPAuthenticationServiceSelectionConfiguration {
        @ConditionalOnMissingBean(name={"samlIdPEntityIdValidationServiceSelectionStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationServiceSelectionStrategy samlIdPEntityIdValidationServiceSelectionStrategy(CasConfigurationProperties casProperties, @Qualifier(value="samlIdPServiceFactory") ServiceFactory samlIdPServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new SamlIdPEntityIdAuthenticationServiceSelectionStrategy(servicesManager, samlIdPServiceFactory, casProperties.getServer().getPrefix());
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPAuthenticationServiceSelectionStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationServiceSelectionStrategyConfigurer samlIdPAuthenticationServiceSelectionStrategyConfigurer(@Qualifier(value="samlIdPEntityIdValidationServiceSelectionStrategy") AuthenticationServiceSelectionStrategy samlIdPEntityIdValidationServiceSelectionStrategy) {
            return plan -> plan.registerStrategy(samlIdPEntityIdValidationServiceSelectionStrategy);
        }
    }

    @Configuration(value="SamlIdPRegisteredServicesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SamlIdPRegisteredServicesConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"samlRegisteredServiceSerializationCustomizer"})
        public JacksonObjectMapperCustomizer samlRegisteredServiceSerializationCustomizer(CasConfigurationProperties casProperties) {
            return JacksonObjectMapperCustomizer.mappedInjectableValues((Map)casProperties.getAuthn().getSamlIdp().getServices().getDefaults());
        }
    }
}

