/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.annotation.Nonnull;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.util.spring.RefreshableHandlerInterceptor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfigureOrder(value=0x7FFFFFFF)
@ConditionalOnBean(name={"authenticationThrottlingExecutionPlan"})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Throttling, CasFeatureModule.FeatureCatalog.SAMLIdentityProvider})
@Configuration(value="SamlIdPThrottleConfiguration", proxyBeanMethods=false)
class SamlIdPThrottleConfiguration {
    SamlIdPThrottleConfiguration() {
    }

    @Configuration(value="SamlIdPThrottleWebMvcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPThrottleWebMvcConfiguration {
        SamlIdPThrottleWebMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPThrottleWebMvcConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebMvcConfigurer samlIdPThrottleWebMvcConfigurer(final @Qualifier(value="authenticationThrottlingExecutionPlan") ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan) {
            return new WebMvcConfigurer(){

                public void addInterceptors(@Nonnull InterceptorRegistry registry) {
                    RefreshableHandlerInterceptor handler = new RefreshableHandlerInterceptor(() -> ((AuthenticationThrottlingExecutionPlan)authenticationThrottlingExecutionPlan.getObject()).getAuthenticationThrottleInterceptors());
                    registry.addInterceptor((HandlerInterceptor)handler).order(0).addPathPatterns(new String[]{"//idp/**"});
                }
            };
        }
    }
}

