/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.gen.HexRandomStringGenerator;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.impl.XSAnyBuilder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.soap.common.SOAPObject;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public abstract class AbstractSamlObjectBuilder
implements Serializable {
    protected static final String DEFAULT_ELEMENT_NAME_FIELD = "DEFAULT_ELEMENT_NAME";
    protected static final String DEFAULT_ELEMENT_LOCAL_NAME_FIELD = "DEFAULT_ELEMENT_LOCAL_NAME";
    private static final int RANDOM_ID_SIZE = 16;
    private static final String SIGNATURE_FACTORY_PROVIDER_CLASS = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static final long serialVersionUID = -6833230731146922780L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlObjectBuilder.class);
    protected OpenSamlConfigBean configBean;

    public AbstractSamlObjectBuilder(OpenSamlConfigBean configBean) {
        this.configBean = configBean;
    }

    public <T extends SAMLObject> T newSamlObject(Class<T> objectType) {
        try {
            QName qName = this.getSamlObjectQName(objectType);
            SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qName);
            if (builder == null) {
                throw new IllegalStateException("No SAML object builder is registered for class " + objectType.getName());
            }
            return (T)((SAMLObject)objectType.cast(builder.buildObject(qName)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T extends SOAPObject> T newSoapObject(Class<T> objectType) {
        try {
            QName qName = this.getSamlObjectQName(objectType);
            SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qName);
            if (builder == null) {
                throw new IllegalStateException("No SAML object builder is registered for class " + objectType.getName());
            }
            return (T)((SOAPObject)objectType.cast(builder.buildObject(qName)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public QName getSamlObjectQName(Class objectType) {
        try {
            Field f = objectType.getField(DEFAULT_ELEMENT_NAME_FIELD);
            return (QName)f.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Cannot find field " + objectType.getName() + '.' + DEFAULT_ELEMENT_NAME_FIELD, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access field " + objectType.getName() + '.' + DEFAULT_ELEMENT_NAME_FIELD, e);
        }
    }

    protected XMLObject newAttributeValue(Object value, QName elementName) {
        XSAnyBuilder attrValueBuilder = new XSAnyBuilder();
        XSAny stringValue = (XSAny)attrValueBuilder.buildObject(elementName);
        stringValue.setTextContent(value.toString());
        return stringValue;
    }

    public String generateSecureRandomId() {
        try {
            HexRandomStringGenerator random = new HexRandomStringGenerator(16);
            String hex = random.getNewString();
            if (StringUtils.isBlank((CharSequence)hex)) {
                throw new IllegalArgumentException("Could not generate a secure random id based on " + random.getAlgorithm());
            }
            return "_" + hex;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create secure random ID generator for SAML message IDs.", e);
        }
    }

    protected void addAttributeValuesToSamlAttribute(String attributeName, Object attributeValue, List<XMLObject> attributeList, QName defaultElementName) {
        if (attributeValue == null) {
            LOGGER.debug("Skipping over SAML attribute [{}] since it has no value", (Object)attributeName);
            return;
        }
        LOGGER.debug("Attempting to generate SAML attribute [{}] with value(s) [{}]", (Object)attributeName, attributeValue);
        if (attributeValue instanceof Collection) {
            Collection c = (Collection)attributeValue;
            LOGGER.debug("Generating multi-valued SAML attribute [{}] with values [{}]", (Object)attributeName, (Object)c);
            c.stream().map(value -> this.newAttributeValue(value, defaultElementName)).forEach(attributeList::add);
        } else {
            LOGGER.debug("Generating SAML attribute [{}] with value [{}]", (Object)attributeName, attributeValue);
            attributeList.add(this.newAttributeValue(attributeValue, defaultElementName));
        }
    }

    public static String signSamlResponse(String samlResponse, PrivateKey privateKey, PublicKey publicKey) {
        Document doc = AbstractSamlObjectBuilder.constructDocumentFromXml(samlResponse);
        if (doc != null) {
            org.jdom.Element signedElement = AbstractSamlObjectBuilder.signSamlElement(doc.getRootElement(), privateKey, publicKey);
            doc.setRootElement((org.jdom.Element)signedElement.detach());
            return new XMLOutputter().outputString(doc);
        }
        throw new IllegalArgumentException("Error signing SAML Response: Null document");
    }

    public static Document constructDocumentFromXml(String xmlString) {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return builder.build((InputStream)new ByteArrayInputStream(xmlString.getBytes(Charset.defaultCharset())));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static org.jdom.Element signSamlElement(org.jdom.Element element, PrivateKey privKey, PublicKey pubKey) {
        try {
            SignatureMethod signatureMethod;
            String algorithm;
            String providerName = System.getProperty("jsr105Provider", SIGNATURE_FACTORY_PROVIDER_CLASS);
            XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            List envelopedTransform = CollectionUtils.wrap((Object)sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference ref = sigFactory.newReference("", sigFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), envelopedTransform, null, null);
            switch (algorithm = pubKey.getAlgorithm()) {
                case "DSA": {
                    signatureMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
                    break;
                }
                case "RSA": {
                    signatureMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error signing SAML element: Unsupported type of key");
                }
            }
            CanonicalizationMethod canonicalizationMethod = sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(canonicalizationMethod, signatureMethod, CollectionUtils.wrap((Object)ref));
            KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
            KeyValue keyValuePair = keyInfoFactory.newKeyValue(pubKey);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(CollectionUtils.wrap((Object)keyValuePair));
            Element w3cElement = AbstractSamlObjectBuilder.toDom(element);
            DOMSignContext dsc = new DOMSignContext(privKey, (Node)w3cElement);
            Node xmlSigInsertionPoint = AbstractSamlObjectBuilder.getXmlSignatureInsertLocation(w3cElement);
            dsc.setNextSibling(xmlSigInsertionPoint);
            XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(dsc);
            return AbstractSamlObjectBuilder.toJdom(w3cElement);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error signing SAML element: " + e.getMessage(), e);
        }
    }

    private static Node getXmlSignatureInsertLocation(Element elem) {
        Node insertLocation;
        NodeList nodeList = elem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Extensions");
        if (nodeList.getLength() != 0) {
            insertLocation = nodeList.item(nodeList.getLength() - 1);
        } else {
            nodeList = elem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Status");
            insertLocation = nodeList.item(nodeList.getLength() - 1);
        }
        return insertLocation;
    }

    private static Element toDom(org.jdom.Element element) {
        return AbstractSamlObjectBuilder.toDom(element.getDocument()).getDocumentElement();
    }

    private static org.w3c.dom.Document toDom(Document doc) {
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            StringWriter elemStrWriter = new StringWriter();
            xmlOutputter.output(doc, (Writer)elemStrWriter);
            byte[] xmlBytes = elemStrWriter.toString().getBytes(Charset.defaultCharset());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xmlBytes));
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public OpenSamlConfigBean getConfigBean() {
        return this.configBean;
    }

    private static org.jdom.Element toJdom(Element e) {
        return new DOMBuilder().build(e);
    }
}

