/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SimpleMFA})
@Configuration(value="CasSimpleMultifactorAuthenticationMultifactorProviderBypassConfiguration", proxyBeanMethods=false)
class CasSimpleMultifactorAuthenticationMultifactorProviderBypassConfiguration {
    CasSimpleMultifactorAuthenticationMultifactorProviderBypassConfiguration() {
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorBypassEvaluator(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSimpleMultifactorHttpRequestMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorHttpRequestMultifactorAuthenticationProviderBypass, @Qualifier(value="casSimpleMultifactorCredentialMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorCredentialMultifactorAuthenticationProviderBypass, @Qualifier(value="casSimpleMultifactorGroovyMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorGroovyMultifactorAuthenticationProviderBypass, @Qualifier(value="casSimpleMultifactorRegisteredServiceMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorRegisteredServiceMultifactorAuthenticationProviderBypass, @Qualifier(value="casSimpleMultifactorAuthenticationMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorAuthenticationMultifactorAuthenticationProviderBypass, @Qualifier(value="casSimpleMultifactorRestMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorRestMultifactorAuthenticationProviderBypass, @Qualifier(value="casSimpleMultifactorPrincipalMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorPrincipalMultifactorAuthenticationProviderBypass, @Qualifier(value="casSimpleRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator") MultifactorAuthenticationProviderBypassEvaluator casSimpleRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator, CasConfigurationProperties casProperties) {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
        MultifactorAuthenticationProviderBypassProperties props = casProperties.getAuthn().getMfa().getSimple().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(casSimpleMultifactorPrincipalMultifactorAuthenticationProviderBypass);
        }
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(casSimpleMultifactorRegisteredServiceMultifactorAuthenticationProviderBypass);
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(casSimpleRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator);
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(casSimpleMultifactorAuthenticationMultifactorAuthenticationProviderBypass);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(casSimpleMultifactorCredentialMultifactorAuthenticationProviderBypass);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(casSimpleMultifactorHttpRequestMultifactorAuthenticationProviderBypass);
        }
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(casSimpleMultifactorGroovyMultifactorAuthenticationProviderBypass);
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(casSimpleMultifactorRestMultifactorAuthenticationProviderBypass);
        return bypass;
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorRestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.simple.bypass.rest.url").given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
            MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
            return new RestMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), applicationContext);
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorGroovyMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.simple.bypass.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
            MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
            return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), applicationContext);
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorHttpRequestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), (ApplicationContext)applicationContext);
    }

    @ConditionalOnMissingBean(name={"casSimpleRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(simple.getId(), applicationContext);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorCredentialMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), applicationContext);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorRegisteredServiceMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(simple.getId(), applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"casSimpleMultifactorPrincipalMultifactorAuthenticationProviderBypass"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorPrincipalMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), (ApplicationContext)applicationContext);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorAuthenticationMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), applicationContext);
    }
}

