/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCommunicationStrategy;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorWebflowConfigurer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SimpleMFA})
@Configuration(value="CasSimpleMultifactorAuthenticationWebflowConfiguration", proxyBeanMethods=false)
class CasSimpleMultifactorAuthenticationWebflowConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;

    CasSimpleMultifactorAuthenticationWebflowConfiguration() {
    }

    @Configuration(value="CasSimpleMultifactorSurrogateAuthenticationWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={SurrogateAuthenticationService.class})
    static class CasSimpleMultifactorSurrogateAuthenticationWebflowPlanConfiguration {
        CasSimpleMultifactorSurrogateAuthenticationWebflowPlanConfiguration() {
        }

        @Bean
        @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SurrogateAuthentication})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateCasSimpleMultifactorAuthenticationWebflowConfigurer"})
        public CasWebflowConfigurer surrogateCasSimpleMultifactorAuthenticationWebflowConfigurer(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new SurrogateWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"surrogateCasSimpleMultifactorAuthenticationWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer surrogateCasSimpleMultifactorAuthenticationWebflowExecutionPlanConfigurer(@Qualifier(value="surrogateCasSimpleMultifactorAuthenticationWebflowConfigurer") CasWebflowConfigurer surrogateWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(surrogateWebflowConfigurer);
        }

        private static final class SurrogateWebflowConfigurer
        extends AbstractCasWebflowConfigurer {
            SurrogateWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry mainFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
                super(flowBuilderServices, mainFlowDefinitionRegistry, applicationContext, casProperties);
                this.setOrder(Integer.MAX_VALUE);
            }

            protected void doInitialize() {
                TransitionableState mfaState = this.getState(this.getLoginFlow(), this.casProperties.getAuthn().getMfa().getSimple().getId());
                this.createTransitionForState(mfaState, "success", "loadSurrogatesAction", true);
            }
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSimpleMultifactorAuthenticationBaseConfiguration {
        CasSimpleMultifactorAuthenticationBaseConfiguration() {
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer mfaSimpleMultifactorWebflowConfigurer(@Qualifier(value="mfaSimpleAuthenticatorFlowRegistry") FlowDefinitionRegistry mfaSimpleAuthenticatorFlowRegistry, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            CasSimpleMultifactorWebflowConfigurer cfg = new CasSimpleMultifactorWebflowConfigurer(flowBuilderServices, loginFlowRegistry, mfaSimpleAuthenticatorFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
            cfg.setOrder(100);
            return cfg;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaSimpleAuthenticatorFlowRegistry"})
        public FlowDefinitionRegistry mfaSimpleAuthenticatorFlowRegistry(CasConfigurationProperties casProperties, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, ConfigurableApplicationContext applicationContext) {
            FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
            builder.addFlowBuilder(flowBuilder, casProperties.getAuthn().getMfa().getSimple().getId());
            return builder.build();
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorTokenCommunicationStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasSimpleMultifactorTokenCommunicationStrategy mfaSimpleMultifactorTokenCommunicationStrategy() {
            return CasSimpleMultifactorTokenCommunicationStrategy.all();
        }
    }
}

