/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.expiration;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.expiration.BaseDelegatingExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class SurrogateSessionExpirationPolicy
extends BaseDelegatingExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateSessionExpirationPolicy.class);
    public static final String POLICY_NAME_SURROGATE = "SURROGATE";
    private static final long serialVersionUID = -2735975347698196127L;

    protected String getExpirationPolicyNameFor(TicketState ticketState) {
        Map attributes = ticketState.getAuthentication().getAttributes();
        if (attributes.containsKey("surrogatePrincipal") && attributes.containsKey("surrogateUser")) {
            LOGGER.trace("Ticket is associated with a surrogate authentication.");
            return POLICY_NAME_SURROGATE;
        }
        LOGGER.trace("Ticket is not associated with a surrogate authentication.");
        return "DEFAULT";
    }

    @Generated
    public String toString() {
        return "SurrogateSessionExpirationPolicy(super=" + super.toString() + ")";
    }
}

