/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.event;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.support.events.AbstractCasEvent;
import org.apereo.cas.support.events.authentication.surrogate.CasSurrogateAuthenticationFailureEvent;
import org.apereo.cas.support.events.authentication.surrogate.CasSurrogateAuthenticationSuccessfulEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class SurrogateAuthenticationEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationEventListener.class);
    private final CommunicationsManager communicationsManager;
    private final CasConfigurationProperties casProperties;

    @EventListener
    @Async
    public void handleSurrogateAuthenticationFailureEvent(CasSurrogateAuthenticationFailureEvent event) {
        this.notify(event.getPrincipal(), (AbstractCasEvent)event);
    }

    @EventListener
    @Async
    public void handleSurrogateAuthenticationSuccessEvent(CasSurrogateAuthenticationSuccessfulEvent event) {
        this.notify(event.getPrincipal(), (AbstractCasEvent)event);
    }

    protected void notify(Principal principal, AbstractCasEvent event) {
        List to;
        String eventDetails = event.toString();
        if (this.communicationsManager.isSmsSenderDefined()) {
            SmsProperties sms = this.casProperties.getAuthn().getSurrogate().getSms();
            String smsAttribute = sms.getAttributeName();
            to = (List)principal.getAttributes().get(smsAttribute);
            if (to != null && StringUtils.isNotBlank((CharSequence)sms.getText())) {
                String text = sms.getFormattedText(new Object[]{"\n\n".concat(eventDetails)});
                this.communicationsManager.sms(sms.getFrom(), to.toString(), text);
            } else {
                LOGGER.trace("The principal has no [{}] attribute, cannot send SMS notification", (Object)smsAttribute);
            }
        } else {
            LOGGER.trace("CAS is unable to send surrogate-authentication SMS messages given no settings are defined to account for servers, etc");
        }
        if (this.communicationsManager.isMailSenderDefined()) {
            EmailProperties mail = this.casProperties.getAuthn().getSurrogate().getMail();
            String emailAttribute = mail.getAttributeName();
            to = (List)principal.getAttributes().get(emailAttribute);
            if (to != null) {
                String body = EmailMessageBodyBuilder.builder().properties(mail).parameters(Map.of("event", eventDetails)).build().produce();
                this.communicationsManager.email(mail, to.toString(), body);
            } else {
                LOGGER.trace("The principal has no [{}] attribute, cannot send email notification", (Object)emailAttribute);
            }
        } else {
            LOGGER.trace("CAS is unable to send surrogate-authentication email messages given no settings are defined to account for servers, etc");
        }
    }

    @Generated
    public SurrogateAuthenticationEventListener(CommunicationsManager communicationsManager, CasConfigurationProperties casProperties) {
        this.communicationsManager = communicationsManager;
        this.casProperties = casProperties;
    }
}

