/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.SurrogateAuthenticationExpirationPolicyBuilder;
import org.apereo.cas.authentication.SurrogateAuthenticationPostProcessor;
import org.apereo.cas.authentication.SurrogateMultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.SurrogatePrincipalBuilder;
import org.apereo.cas.authentication.SurrogatePrincipalElectionStrategy;
import org.apereo.cas.authentication.SurrogatePrincipalResolver;
import org.apereo.cas.authentication.audit.SurrogateAuditPrincipalIdProvider;
import org.apereo.cas.authentication.event.SurrogateAuthenticationEventListener;
import org.apereo.cas.authentication.principal.PrincipalElectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolutionExecutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.surrogate.JsonResourceSurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SimpleSurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.expiration.builder.TicketGrantingTicketExpirationPolicyBuilder;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="surrogateAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SurrogateAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationConfiguration.class);
    @Autowired
    @Qualifier(value="attributeRepository")
    private ObjectProvider<IPersonAttributeDao> attributeRepository;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="communicationsManager")
    private ObjectProvider<CommunicationsManager> communicationsManager;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="surrogateEligibilityAuditableExecution")
    private ObjectProvider<AuditableExecution> surrogateEligibilityAuditableExecution;

    @Bean
    @RefreshScope
    public ExpirationPolicyBuilder grantingTicketExpirationPolicy() {
        TicketGrantingTicketExpirationPolicyBuilder grantingTicketExpirationPolicy = new TicketGrantingTicketExpirationPolicyBuilder(this.casProperties);
        return new SurrogateAuthenticationExpirationPolicyBuilder((ExpirationPolicyBuilder<TicketGrantingTicket>)grantingTicketExpirationPolicy, this.casProperties);
    }

    @ConditionalOnMissingBean(name={"surrogatePrincipalFactory"})
    @RefreshScope
    @Bean
    public PrincipalFactory surrogatePrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"surrogateAuthenticationService"})
    @Bean
    public SurrogateAuthenticationService surrogateAuthenticationService() {
        SurrogateAuthenticationProperties su = this.casProperties.getAuthn().getSurrogate();
        if (su.getJson().getLocation() != null) {
            LOGGER.debug("Using JSON resource [{}] to locate surrogate accounts", (Object)su.getJson().getLocation());
            return new JsonResourceSurrogateAuthenticationService(su.getJson().getLocation(), (ServicesManager)this.servicesManager.getObject());
        }
        HashMap<String, List> accounts = new HashMap<String, List>();
        su.getSimple().getSurrogates().forEach((k, v) -> accounts.put((String)k, new ArrayList(StringUtils.commaDelimitedListToSet((String)v))));
        LOGGER.debug("Using accounts [{}] for surrogate authentication", accounts);
        return new SimpleSurrogateAuthenticationService(accounts, (ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"surrogateAuthenticationPostProcessor"})
    @Bean
    @RefreshScope
    public AuthenticationPostProcessor surrogateAuthenticationPostProcessor() {
        return new SurrogateAuthenticationPostProcessor(this.surrogateAuthenticationService(), (ServicesManager)this.servicesManager.getObject(), (ApplicationEventPublisher)this.applicationContext, (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (AuditableExecution)this.surrogateEligibilityAuditableExecution.getObject());
    }

    @ConditionalOnMissingBean(name={"surrogatePrincipalBuilder"})
    @Bean
    @RefreshScope
    public SurrogatePrincipalBuilder surrogatePrincipalBuilder() {
        return new SurrogatePrincipalBuilder(this.surrogatePrincipalFactory(), (IPersonAttributeDao)this.attributeRepository.getObject(), this.surrogateAuthenticationService());
    }

    @Bean
    @ConditionalOnMissingBean(name={"surrogateMultifactorAuthenticationPrincipalResolver"})
    @RefreshScope
    public MultifactorAuthenticationPrincipalResolver surrogateMultifactorAuthenticationPrincipalResolver() {
        return new SurrogateMultifactorAuthenticationPrincipalResolver();
    }

    @ConditionalOnMissingBean(name={"surrogatePrincipalElectionStrategyConfigurer"})
    @Bean
    @RefreshScope
    public PrincipalElectionStrategyConfigurer surrogatePrincipalElectionStrategyConfigurer() {
        return chain -> {
            SurrogatePrincipalElectionStrategy strategy = new SurrogatePrincipalElectionStrategy();
            IAttributeMerger merger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
            strategy.setAttributeMerger(merger);
            chain.registerElectionStrategy((PrincipalElectionStrategy)strategy);
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"surrogateAuditPrincipalIdProvider"})
    public AuditPrincipalIdProvider surrogateAuditPrincipalIdProvider() {
        return new SurrogateAuditPrincipalIdProvider();
    }

    @ConditionalOnMissingBean(name={"surrogateAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public AuthenticationEventExecutionPlanConfigurer surrogateAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationPostProcessor(this.surrogateAuthenticationPostProcessor());
    }

    @ConditionalOnMissingBean(name={"surrogateAuthenticationEventListener"})
    @Bean
    public SurrogateAuthenticationEventListener surrogateAuthenticationEventListener() {
        return new SurrogateAuthenticationEventListener((CommunicationsManager)this.communicationsManager.getObject(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"surrogatePrincipalResolver"})
    @Bean
    @RefreshScope
    public PrincipalResolver surrogatePrincipalResolver() {
        PersonDirectoryPrincipalResolverProperties principal = this.casProperties.getAuthn().getSurrogate().getPrincipal();
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        SurrogatePrincipalResolver resolver = (SurrogatePrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)this.surrogatePrincipalFactory(), (IPersonAttributeDao)((IPersonAttributeDao)this.attributeRepository.getObject()), (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), SurrogatePrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setSurrogatePrincipalBuilder(this.surrogatePrincipalBuilder());
        return resolver;
    }

    @ConditionalOnMissingBean(name={"surrogatePrincipalResolutionExecutionPlanConfigurer"})
    @Bean
    public PrincipalResolutionExecutionPlanConfigurer surrogatePrincipalResolutionExecutionPlanConfigurer() {
        return plan -> plan.registerPrincipalResolver(this.surrogatePrincipalResolver());
    }
}

