/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.SurrogateRegisteredServiceAccessStrategy;
import org.apereo.cas.ticket.expiration.SurrogateSessionExpirationPolicy;
import org.apereo.cas.util.serialization.ComponentSerializationPlanConfigurer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SurrogateAuthentication})
@AutoConfiguration
public class SurrogateComponentSerializationConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"surrogateComponentSerializationPlanConfigurer"})
    public ComponentSerializationPlanConfigurer surrogateComponentSerializationPlanConfigurer() {
        return plan -> {
            plan.registerSerializableClass(SurrogateSessionExpirationPolicy.class);
            plan.registerSerializableClass(SurrogateRegisteredServiceAccessStrategy.class);
        };
    }
}

