/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.DefaultSurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.SurrogateAuthenticationExpirationPolicyBuilder;
import org.apereo.cas.authentication.SurrogateAuthenticationPostProcessor;
import org.apereo.cas.authentication.SurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.SurrogateMultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.SurrogatePrincipalElectionStrategy;
import org.apereo.cas.authentication.SurrogatePrincipalResolver;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.attribute.AttributeRepositoryResolver;
import org.apereo.cas.authentication.event.DefaultSurrogateAuthenticationEventListener;
import org.apereo.cas.authentication.event.SurrogateAuthenticationEventListener;
import org.apereo.cas.authentication.principal.PrincipalElectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolutionExecutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.authentication.surrogate.ChainingSurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.GroovySurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.JsonResourceSurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SimpleSurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.expiration.builder.TicketGrantingTicketExpirationPolicyBuilder;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SurrogateAuthentication})
@Configuration(value="SurrogateAuthenticationConfiguration", proxyBeanMethods=false)
class SurrogateAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationConfiguration.class);

    SurrogateAuthenticationConfiguration() {
    }

    @Configuration(value="SurrogateAuthenticationPrincipalPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationPrincipalPlanConfiguration {
        SurrogateAuthenticationPrincipalPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogatePrincipalResolutionExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolutionExecutionPlanConfigurer surrogatePrincipalResolutionExecutionPlanConfigurer(@Qualifier(value="surrogatePrincipalResolver") PrincipalResolver surrogatePrincipalResolver) {
            return plan -> plan.registerPrincipalResolver(surrogatePrincipalResolver);
        }
    }

    @Configuration(value="SurrogateAuthenticationPrincipalFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationPrincipalFactoryConfiguration {
        SurrogateAuthenticationPrincipalFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogatePrincipalFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public PrincipalFactory surrogatePrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }

    @Configuration(value="SurrogateAuthenticationPrincipalResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @DependsOn(value={"attributeRepository"})
    static class SurrogateAuthenticationPrincipalResolutionConfiguration {
        SurrogateAuthenticationPrincipalResolutionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogatePrincipalResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolver surrogatePrincipalResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="surrogatePrincipalFactory") PrincipalFactory surrogatePrincipalFactory, @Qualifier(value="surrogatePrincipalBuilder") SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository, @Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver) {
            PersonDirectoryPrincipalResolverProperties principal = casProperties.getAuthn().getSurrogate().getPrincipal();
            PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
            AttributeMerger attributeMerger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
            SurrogatePrincipalResolver resolver = (SurrogatePrincipalResolver)PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)surrogatePrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)attributeMerger, SurrogatePrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
            resolver.setSurrogatePrincipalBuilder(surrogatePrincipalBuilder);
            return resolver;
        }
    }

    @Configuration(value="SurrogateAuthenticationPrincipalBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationPrincipalBuilderConfiguration {
        SurrogateAuthenticationPrincipalBuilderConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogatePrincipalBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder(@Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver, CasConfigurationProperties casProperties, @Qualifier(value="surrogateAuthenticationService") SurrogateAuthenticationService surrogateAuthenticationService, @Qualifier(value="surrogatePrincipalFactory") PrincipalFactory surrogatePrincipalFactory, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository) throws Exception {
            return new DefaultSurrogateAuthenticationPrincipalBuilder(surrogatePrincipalFactory, attributeRepository, surrogateAuthenticationService, attributeRepositoryResolver, casProperties);
        }
    }

    @Configuration(value="SurrogateAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationPlanConfiguration {
        SurrogateAuthenticationPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogateAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer surrogateAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="surrogateAuthenticationPostProcessor") AuthenticationPostProcessor surrogateAuthenticationPostProcessor) throws Exception {
            return plan -> plan.registerAuthenticationPostProcessor(surrogateAuthenticationPostProcessor);
        }
    }

    @Configuration(value="SurrogateAuthenticationServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationServiceConfiguration {
        SurrogateAuthenticationServiceConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateAuthenticationService"})
        @Bean
        public SurrogateAuthenticationService surrogateAuthenticationService(@Qualifier(value="servicesManager") ServicesManager servicesManager, List<BeanSupplier<SurrogateAuthenticationService>> surrogateServiceSuppliers) {
            List<SurrogateAuthenticationService> allServices = surrogateServiceSuppliers.stream().map(BeanSupplier::get).filter(BeanSupplier::isNotProxy).sorted((Comparator<SurrogateAuthenticationService>)AnnotationAwareOrderComparator.INSTANCE).toList();
            return new ChainingSurrogateAuthenticationService(allServices, servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"groovySurrogateAuthenticationService"})
        public BeanSupplier<SurrogateAuthenticationService> groovySurrogateAuthenticationService(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return BeanSupplier.of(SurrogateAuthenticationService.class).when(() -> casProperties.getAuthn().getSurrogate().getGroovy().getLocation() != null).supply(Unchecked.supplier(() -> {
                SurrogateAuthenticationProperties su = casProperties.getAuthn().getSurrogate();
                LOGGER.debug("Using Groovy resource [{}] to locate surrogate accounts", (Object)su.getGroovy().getLocation());
                return new GroovySurrogateAuthenticationService(servicesManager, casProperties);
            })).otherwiseNull();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jsonSurrogateAuthenticationService"})
        public BeanSupplier<SurrogateAuthenticationService> jsonSurrogateAuthenticationService(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return BeanSupplier.of(SurrogateAuthenticationService.class).when(() -> casProperties.getAuthn().getSurrogate().getJson().getLocation() != null).supply(Unchecked.supplier(() -> {
                SurrogateAuthenticationProperties su = casProperties.getAuthn().getSurrogate();
                LOGGER.debug("Using JSON resource [{}] to locate surrogate accounts", (Object)su.getJson().getLocation());
                return new JsonResourceSurrogateAuthenticationService(servicesManager, casProperties);
            })).otherwiseNull();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"simpleSurrogateAuthenticationService"})
        public BeanSupplier<SurrogateAuthenticationService> simpleSurrogateAuthenticationService(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return BeanSupplier.of(SurrogateAuthenticationService.class).alwaysMatch().supply(() -> {
                SurrogateAuthenticationProperties su = casProperties.getAuthn().getSurrogate();
                HashMap accounts = new HashMap();
                su.getSimple().getSurrogates().forEach((user, v) -> accounts.put(user, new ArrayList(StringUtils.commaDelimitedListToSet((String)v))));
                LOGGER.debug("Using accounts [{}] for surrogate authentication", accounts);
                return new SimpleSurrogateAuthenticationService(accounts, servicesManager, casProperties);
            });
        }
    }

    @Configuration(value="SurrogateAuthenticationPrincipalElectionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationPrincipalElectionConfiguration {
        SurrogateAuthenticationPrincipalElectionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogatePrincipalElectionStrategyConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalElectionStrategyConfigurer surrogatePrincipalElectionStrategyConfigurer(CasConfigurationProperties casProperties) {
            return chain -> {
                SurrogatePrincipalElectionStrategy strategy = new SurrogatePrincipalElectionStrategy();
                AttributeMerger merger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
                strategy.setAttributeMerger(merger);
                chain.registerElectionStrategy((PrincipalElectionStrategy)strategy);
            };
        }
    }

    @Configuration(value="SurrogateAuthenticationEventsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationEventsConfiguration {
        SurrogateAuthenticationEventsConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogateAuthenticationEventListener"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public SurrogateAuthenticationEventListener surrogateAuthenticationEventListener(@Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, CasConfigurationProperties casProperties) {
            return new DefaultSurrogateAuthenticationEventListener(communicationsManager, casProperties);
        }
    }

    @Configuration(value="SurrogateAuthenticationExpirationPolicyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationExpirationPolicyConfiguration {
        SurrogateAuthenticationExpirationPolicyConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder grantingTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            TicketGrantingTicketExpirationPolicyBuilder grantingTicketExpirationPolicy = new TicketGrantingTicketExpirationPolicyBuilder(casProperties);
            return new SurrogateAuthenticationExpirationPolicyBuilder((ExpirationPolicyBuilder)grantingTicketExpirationPolicy, casProperties);
        }
    }

    @Configuration(value="SurrogateAuthenticationMultifactorPrincipalResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationMultifactorPrincipalResolutionConfiguration {
        SurrogateAuthenticationMultifactorPrincipalResolutionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"surrogateMultifactorAuthenticationPrincipalResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationPrincipalResolver surrogateMultifactorAuthenticationPrincipalResolver() {
            return new SurrogateMultifactorAuthenticationPrincipalResolver();
        }
    }

    @Configuration(value="SurrogateAuthenticationProcessorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SurrogateAuthenticationProcessorConfiguration {
        SurrogateAuthenticationProcessorConfiguration() {
        }

        @ConditionalOnMissingBean(name={"surrogateAuthenticationPostProcessor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationPostProcessor surrogateAuthenticationPostProcessor(@Qualifier(value="surrogateAuthenticationService") SurrogateAuthenticationService surrogateAuthenticationService, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="surrogateEligibilityAuditableExecution") AuditableExecution surrogateEligibilityAuditableExecution, ConfigurableApplicationContext applicationContext) throws Exception {
            return new SurrogateAuthenticationPostProcessor(surrogateAuthenticationService, servicesManager, (ApplicationEventPublisher)applicationContext, registeredServiceAccessStrategyEnforcer, surrogateEligibilityAuditableExecution);
        }
    }
}

