/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Set;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.SurrogatePrincipalBuilder;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SurrogateWebflowConfigurer;
import org.apereo.cas.web.flow.action.LoadSurrogatesListAction;
import org.apereo.cas.web.flow.action.SurrogateAuthorizationAction;
import org.apereo.cas.web.flow.action.SurrogateInitialAuthenticationAction;
import org.apereo.cas.web.flow.action.SurrogateSelectionAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="surrogateAuthenticationWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SurrogateAuthenticationWebflowConfiguration
implements InitializingBean {
    @Autowired
    @Qualifier(value="surrogatePrincipalBuilder")
    private ObjectProvider<SurrogatePrincipalBuilder> surrogatePrincipalBuilder;
    @Autowired
    @Qualifier(value="surrogateAuthenticationService")
    private ObjectProvider<SurrogateAuthenticationService> surrogateAuthenticationService;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private ObjectProvider<AdaptiveAuthenticationPolicy> adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private ObjectProvider<CasWebflowEventResolver> serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="handledAuthenticationExceptions")
    private Set<Class<? extends Throwable>> handledAuthenticationExceptions;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @ConditionalOnMissingBean(name={"surrogateWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer surrogateWebflowConfigurer() {
        return new SurrogateWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.applicationContext, this.casProperties);
    }

    @ConditionalOnMissingBean(name={"selectSurrogateAction"})
    @Bean
    @RefreshScope
    public Action selectSurrogateAction() {
        return new SurrogateSelectionAction((SurrogatePrincipalBuilder)this.surrogatePrincipalBuilder.getObject());
    }

    @Bean
    public Action authenticationViaFormAction() {
        return new SurrogateInitialAuthenticationAction((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getObject(), (CasWebflowEventResolver)this.serviceTicketRequestWebflowEventResolver.getObject(), (AdaptiveAuthenticationPolicy)this.adaptiveAuthenticationPolicy.getObject(), this.casProperties.getAuthn().getSurrogate().getSeparator());
    }

    @ConditionalOnMissingBean(name={"surrogateAuthorizationCheck"})
    @Bean
    @RefreshScope
    public Action surrogateAuthorizationCheck() {
        return new SurrogateAuthorizationAction((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }

    @ConditionalOnMissingBean(name={"loadSurrogatesListAction"})
    @Bean
    @RefreshScope
    public Action loadSurrogatesListAction() {
        return new LoadSurrogatesListAction((SurrogateAuthenticationService)this.surrogateAuthenticationService.getObject(), (SurrogatePrincipalBuilder)this.surrogatePrincipalBuilder.getObject());
    }

    public void afterPropertiesSet() {
        this.handledAuthenticationExceptions.add(SurrogateAuthenticationException.class);
    }

    @Bean
    @ConditionalOnMissingBean(name={"surrogateCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer surrogateCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.surrogateWebflowConfigurer());
    }
}

