/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class SurrogateWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateWebflowConfigurer.class);
    public static final String TRANSITION_ID_SURROGATE_VIEW = "surrogateListView";
    public static final String TRANSITION_ID_SKIP_SURROGATE = "skipSurrogateView";
    static final String STATE_ID_SURROGATE_VIEW = "surrogateListView";
    static final String STATE_ID_LOAD_SURROGATES_ACTION = "loadSurrogatesAction";
    static final String STATE_ID_SELECT_SURROGATE = "selectSurrogate";
    private static final String VIEW_ID_CAS_SURROGATE_AUTHN_LIST_VIEW = "casSurrogateAuthnListView";
    private static final String ACTION_ID_LOAD_SURROGATES_LIST_ACTION = "loadSurrogatesListAction";
    private static final String ACTION_ID_SELECT_SURROGATE_ACTION = "selectSurrogateAction";

    public SurrogateWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createSurrogateListViewState(flow);
            this.createSurrogateSelectionActionState(flow);
            this.createSurrogateAuthorizationActionState(flow);
            this.createTransitionToInjectSurrogateIntoFlow(flow);
        }
    }

    private void createSurrogateAuthorizationActionState(Flow flow) {
        ActionState actionState = (ActionState)this.getState(flow, "generateServiceTicket", ActionState.class);
        actionState.getEntryActionList().add((Action)this.createEvaluateAction("surrogateAuthorizationCheck"));
    }

    private void createTransitionToInjectSurrogateIntoFlow(Flow flow) {
        ActionState actionState = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
        LOGGER.debug("Locating transition id [{}] to for state [{}", (Object)"success", (Object)actionState.getId());
        String targetSuccessId = actionState.getTransition("success").getTargetStateId();
        ActionState loadSurrogatesAction = this.createActionState(flow, STATE_ID_LOAD_SURROGATES_ACTION, ACTION_ID_LOAD_SURROGATES_LIST_ACTION);
        this.createTransitionForState((TransitionableState)loadSurrogatesAction, "success", targetSuccessId);
        this.createTransitionForState((TransitionableState)loadSurrogatesAction, "surrogateListView", "surrogateListView");
        this.createTransitionForState((TransitionableState)loadSurrogatesAction, TRANSITION_ID_SKIP_SURROGATE, targetSuccessId);
        this.createTransitionForState((TransitionableState)actionState, "success", loadSurrogatesAction.getId(), true);
    }

    private void createSurrogateSelectionActionState(Flow flow) {
        ActionState selectSurrogate = this.createActionState(flow, STATE_ID_SELECT_SURROGATE, ACTION_ID_SELECT_SURROGATE_ACTION);
        ActionState actionState = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
        String targetSuccessId = actionState.getTransition("success").getTargetStateId();
        this.createTransitionForState((TransitionableState)selectSurrogate, "success", targetSuccessId);
        this.createTransitionForState((TransitionableState)selectSurrogate, "error", "surrogateListView");
    }

    private void createSurrogateListViewState(Flow flow) {
        ViewState viewState = this.createViewState(flow, "surrogateListView", VIEW_ID_CAS_SURROGATE_AUTHN_LIST_VIEW);
        this.createTransitionForState((TransitionableState)viewState, "submit", STATE_ID_SELECT_SURROGATE);
    }
}

