/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogatePrincipalBuilder;
import org.apereo.cas.authentication.SurrogateUsernamePasswordCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class LoadSurrogatesListAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadSurrogatesListAction.class);
    private final SurrogateAuthenticationService surrogateService;
    private final SurrogatePrincipalBuilder surrogatePrincipalBuilder;

    private boolean loadSurrogates(RequestContext requestContext) {
        Credential c = WebUtils.getCredential((RequestContext)requestContext);
        if (c instanceof UsernamePasswordCredential) {
            String username = c.getId();
            LOGGER.debug("Loading eligible accounts for [{}] to proxy", (Object)username);
            ArrayList surrogates = this.surrogateService.getEligibleAccountsForSurrogateToProxy(username).stream().sorted().distinct().collect(Collectors.toCollection(ArrayList::new));
            LOGGER.debug("Surrogate accounts found are [{}]", (Object)surrogates);
            if (!surrogates.isEmpty()) {
                if (!surrogates.contains(username)) {
                    surrogates.add(0, username);
                }
                WebUtils.putSurrogateAuthenticationAccounts((RequestContext)requestContext, (List)surrogates);
                return true;
            }
            LOGGER.debug("No surrogate accounts could be located for [{}]", (Object)username);
        } else {
            LOGGER.debug("Current credential in the webflow is not one of [{}]", (Object)UsernamePasswordCredential.class.getName());
        }
        return false;
    }

    protected Event doExecute(RequestContext requestContext) {
        if (WebUtils.hasRequestSurrogateAuthenticationRequest((RequestContext)requestContext)) {
            WebUtils.removeRequestSurrogateAuthenticationRequest((RequestContext)requestContext);
            LOGGER.trace("Attempting to load surrogates...");
            if (this.loadSurrogates(requestContext)) {
                return new Event((Object)this, "surrogateListView");
            }
            return new EventFactorySupport().event((Object)this, "skipSurrogateView");
        }
        Credential currentCredential = WebUtils.getCredential((RequestContext)requestContext);
        if (currentCredential instanceof SurrogateUsernamePasswordCredential) {
            AuthenticationResultBuilder authenticationResultBuilder = WebUtils.getAuthenticationResultBuilder((RequestContext)requestContext);
            SurrogateUsernamePasswordCredential credential = (SurrogateUsernamePasswordCredential)currentCredential;
            RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
            Optional result = this.surrogatePrincipalBuilder.buildSurrogateAuthenticationResult(authenticationResultBuilder, currentCredential, credential.getSurrogateUsername(), registeredService);
            result.ifPresent(builder -> WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)requestContext));
        }
        return this.success();
    }

    @Generated
    public LoadSurrogatesListAction(SurrogateAuthenticationService surrogateService, SurrogatePrincipalBuilder surrogatePrincipalBuilder) {
        this.surrogateService = surrogateService;
        this.surrogatePrincipalBuilder = surrogatePrincipalBuilder;
    }
}

