/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class SurrogateWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateWebflowConfigurer.class);

    public SurrogateWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(Integer.MAX_VALUE);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createSurrogateAuthenticationActionState(flow);
            this.createSurrogateListViewState(flow);
            this.createSurrogateSelectionActionState(flow);
            this.createSurrogateAuthorizationActionState(flow);
            this.createTransitionToInjectSurrogateIntoFlow(flow);
        }
    }

    private void createSurrogateAuthenticationActionState(Flow flow) {
        ActionState state = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
        this.prependActionsToActionStateExecutionList(flow, state, new EvaluateAction[]{this.createEvaluateAction("surrogateInitialAuthenticationAction")});
    }

    protected void createSurrogateListViewState(Flow flow) {
        ViewState viewState = this.createViewState(flow, "surrogateListView", "surrogate/casSurrogateAuthnListView");
        this.createTransitionForState((TransitionableState)viewState, "submit", "selectSurrogate");
        this.createEndState(flow, "surrogateWildcardView", "surrogate/casSurrogateAuthnWildcardView");
    }

    private void createSurrogateAuthorizationActionState(Flow flow) {
        ActionState actionState = (ActionState)this.getState(flow, "generateServiceTicket", ActionState.class);
        actionState.getEntryActionList().add((Action)this.createEvaluateAction("surrogateAuthorizationCheck"));
    }

    private void createTransitionToInjectSurrogateIntoFlow(Flow flow) {
        ActionState actionState = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
        LOGGER.debug("Locating transition id [{}] to for state [{}", (Object)"success", (Object)actionState.getId());
        String targetSuccessId = actionState.getTransition("success").getTargetStateId();
        ActionState loadSurrogatesAction = this.createActionState(flow, "loadSurrogatesAction", new String[]{"loadSurrogatesListAction"});
        this.createTransitionForState((TransitionableState)loadSurrogatesAction, "success", targetSuccessId);
        this.createTransitionForState((TransitionableState)loadSurrogatesAction, "surrogateListView", "surrogateListView");
        this.createTransitionForState((TransitionableState)loadSurrogatesAction, "surrogateWildcardView", "surrogateWildcardView");
        this.createTransitionForState((TransitionableState)loadSurrogatesAction, "skipSurrogateView", targetSuccessId);
        this.createTransitionForState((TransitionableState)loadSurrogatesAction, "error", "viewLoginForm");
        this.createTransitionForState((TransitionableState)actionState, "success", loadSurrogatesAction.getId(), true);
    }

    private void createSurrogateSelectionActionState(Flow flow) {
        ActionState selectSurrogate = this.createActionState(flow, "selectSurrogate", new String[]{"selectSurrogateAction"});
        ActionState actionState = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
        String targetSuccessId = actionState.getTransition("success").getTargetStateId();
        this.createTransitionForState((TransitionableState)selectSurrogate, "success", targetSuccessId);
        this.createTransitionForState((TransitionableState)selectSurrogate, "error", "surrogateListView");
    }
}

