/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.action;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialTrait;
import org.apereo.cas.authentication.MutableCredential;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationRequest;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialParser;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SurrogateInitialAuthenticationAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateInitialAuthenticationAction.class);
    private final SurrogateCredentialParser surrogateCredentialParser;

    protected Event doExecute(RequestContext context) {
        MutableCredential credential = (MutableCredential)WebUtils.getCredential((RequestContext)context, MutableCredential.class);
        FunctionUtils.doIfNotNull((Object)credential, __ -> {
            Optional surrogateRequest = this.surrogateCredentialParser.parse(credential);
            surrogateRequest.ifPresentOrElse(payload -> SurrogateInitialAuthenticationAction.addSurrogateInformation(context, payload), () -> SurrogateInitialAuthenticationAction.removeSurrogateInformation(context, Objects.requireNonNull(credential)));
        });
        return null;
    }

    private static void addSurrogateInformation(RequestContext context, SurrogateAuthenticationRequest surrogateRequest) {
        MutableCredential credential = surrogateRequest.getCredential();
        credential.setId(surrogateRequest.getUsername());
        if (surrogateRequest.hasSurrogateUsername()) {
            WebUtils.putSurrogateAuthenticationRequest((RequestContext)context, (Boolean)Boolean.TRUE);
            LOGGER.debug("No surrogate username is defined; Signal webflow to request for surrogate credentials");
        } else {
            credential.getCredentialMetadata().addTrait((CredentialTrait)new SurrogateCredentialTrait(surrogateRequest.getSurrogateUsername()));
            WebUtils.putSurrogateAuthenticationRequest((RequestContext)context, (Boolean)Boolean.FALSE);
            LOGGER.debug("Converted credential to surrogate for username [{}] and assigned it to webflow", (Object)surrogateRequest.getUsername());
        }
        WebUtils.putCredential((RequestContext)context, (Credential)credential);
    }

    private static void removeSurrogateInformation(RequestContext context, MutableCredential credential) {
        credential.getCredentialMetadata().removeTrait(SurrogateCredentialTrait.class);
        WebUtils.putCredential((RequestContext)context, (Credential)credential);
    }

    @Generated
    public SurrogateInitialAuthenticationAction(SurrogateCredentialParser surrogateCredentialParser) {
        this.surrogateCredentialParser = surrogateCredentialParser;
    }
}

