/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.pac4j;

import java.util.Optional;
import org.apereo.cas.api.PasswordlessAuthenticationRequest;
import org.apereo.cas.authentication.CredentialTrait;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.DefaultDelegatedAuthenticationCredentialExtractor;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.web.flow.PasswordlessWebflowUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.springframework.webflow.execution.RequestContext;

public class SurrogateDelegatedAuthenticationCredentialExtractor
extends DefaultDelegatedAuthenticationCredentialExtractor {
    public SurrogateDelegatedAuthenticationCredentialExtractor(SessionStore sessionStore) {
        super(sessionStore);
    }

    protected ClientCredential buildClientCredential(BaseClient client, RequestContext requestContext, Credentials credential) {
        ClientCredential cc = super.buildClientCredential(client, requestContext, credential);
        PasswordlessAuthenticationRequest passwordlessRequest = (PasswordlessAuthenticationRequest)PasswordlessWebflowUtils.getPasswordlessAuthenticationRequest((RequestContext)requestContext, PasswordlessAuthenticationRequest.class);
        Optional.ofNullable(passwordlessRequest).ifPresent(request -> {
            if (passwordlessRequest.getProperties().containsKey("surrogateUsername")) {
                String surrogateUsername = (String)passwordlessRequest.getProperties().get("surrogateUsername");
                cc.getCredentialMetadata().addTrait((CredentialTrait)new SurrogateCredentialTrait(surrogateUsername));
            }
        });
        return cc;
    }
}

