/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.action;

import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialTrait;
import org.apereo.cas.authentication.MutableCredential;
import org.apereo.cas.authentication.SurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SurrogateSelectionAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateSelectionAction.class);
    public static final String PARAMETER_NAME_SURROGATE_TARGET = "surrogateTarget";
    private final SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder;

    @Audit(action="SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION", actionResolverName="SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_ACTION_RESOLVER", resourceResolverName="SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_RESOURCE_RESOLVER")
    protected Event doExecuteInternal(RequestContext requestContext) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            Credential credential = WebUtils.getCredential((RequestContext)requestContext);
            if (credential instanceof MutableCredential) {
                MutableCredential mutableCredential = (MutableCredential)credential;
                String surrogateTarget = WebUtils.getRequestParameterOrAttribute((RequestContext)requestContext, (String)PARAMETER_NAME_SURROGATE_TARGET).orElse("");
                LOGGER.debug("Located surrogate target as [{}]", (Object)surrogateTarget);
                if (StringUtils.isNotBlank((CharSequence)surrogateTarget)) {
                    resultMap.put(PARAMETER_NAME_SURROGATE_TARGET, surrogateTarget);
                    RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
                    AuthenticationResultBuilder builder = WebUtils.getAuthenticationResultBuilder((RequestContext)requestContext);
                    mutableCredential.getCredentialMetadata().addTrait((CredentialTrait)new SurrogateCredentialTrait(surrogateTarget));
                    Optional result = this.surrogatePrincipalBuilder.buildSurrogateAuthenticationResult(builder, (Credential)mutableCredential, registeredService);
                    result.ifPresent(bldr -> WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)bldr, (RequestContext)requestContext));
                } else {
                    LOGGER.warn("No surrogate identifier was selected or provided");
                }
                resultMap.put("primary", credential.getId());
            } else {
                LOGGER.debug("Credential is not supported [{}]", (Object)credential);
            }
            return this.success(resultMap);
        }
        catch (Throwable e) {
            WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)"screen.surrogates.account.selection.error", (String)"Unable to accept or authorize selection");
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.error(new RuntimeException(e));
        }
    }

    @Generated
    public SurrogateSelectionAction(SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder) {
        this.surrogatePrincipalBuilder = surrogatePrincipalBuilder;
    }
}

