/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.base.Splitter;
import java.util.List;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAuthenticationProperties;
import org.apereo.cas.configuration.model.support.syncope.SyncopePrincipalAttributesProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.syncope.SyncopePersonAttributeDao;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="syncope")
@Configuration(value="SyncopePersonDirectoryConfiguration", proxyBeanMethods=false)
class SyncopePersonDirectoryConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.syncope.url").isUrl();

    SyncopePersonDirectoryConfiguration() {
    }

    @ConditionalOnMissingBean(name={"syncopePersonAttributeDaos"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public BeanContainer<PersonAttributeDao> syncopePersonAttributeDaos(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
        return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            SyncopePrincipalAttributesProperties properties = casProperties.getAuthn().getAttributeRepository().getSyncope();
            SyncopeAuthenticationProperties syncope = casProperties.getAuthn().getSyncope();
            List<SyncopePersonAttributeDao> repositories = Splitter.on((String)",").splitToList((CharSequence)syncope.getDomain()).stream().map(domain -> {
                SyncopePersonAttributeDao dao = new SyncopePersonAttributeDao(properties);
                dao.setOrder(properties.getOrder());
                FunctionUtils.doIfNotNull((Object)properties.getId(), id -> dao.setId(new String[]{id}));
                return dao;
            }).toList();
            return BeanContainer.of(repositories);
        }).otherwise(BeanContainer::empty).get();
    }

    @ConditionalOnMissingBean(name={"syncopeAttributeRepositoryPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PersonDirectoryAttributeRepositoryPlanConfigurer syncopeAttributeRepositoryPlanConfigurer(@Qualifier(value="syncopePersonAttributeDaos") BeanContainer<PersonAttributeDao> syncopePersonAttributeDaos) {
        return plan -> syncopePersonAttributeDaos.toList().stream().filter(PersonAttributeDao::isEnabled).forEach(arg_0 -> ((PersonDirectoryAttributeRepositoryPlan)plan).registerAttributeRepository(arg_0));
    }
}

