/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.TicketGrantingCookieProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.ChainingThemeResolver;
import org.apereo.cas.services.web.RegisteredServiceThemeResolver;
import org.apereo.cas.services.web.RequestHeaderThemeResolver;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.theme.CookieThemeResolver;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.theme.SessionThemeResolver;

@Configuration(value="casThemesConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class, WebProperties.class})
public class CasThemesConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasThemesConfiguration.class);
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ObjectProvider<ThymeleafProperties> thymeleafProperties;
    @Autowired
    private WebProperties webProperties;

    @Bean
    public Supplier<Map<String, String>> serviceThemeResolverSupportedBrowsers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(".*Android.*", "android");
        map.put(".*Safari.*Pre.*", "safari");
        map.put(".*iPhone.*", "iphone");
        map.put(".*Nokia.*AppleWebKit.*", "nokiawebkit");
        return () -> map;
    }

    @ConditionalOnMissingBean(name={"casThemeResolver"})
    @Bean
    @Autowired
    public ThemeResolver themeResolver(@Qualifier(value="serviceThemeResolverSupportedBrowsers") Supplier<Map<String, String>> serviceThemeResolverSupportedBrowsers) {
        String defaultThemeName = this.casProperties.getTheme().getDefaultThemeName();
        FixedThemeResolver fixedResolver = new FixedThemeResolver();
        fixedResolver.setDefaultThemeName(defaultThemeName);
        SessionThemeResolver sessionThemeResolver = new SessionThemeResolver();
        sessionThemeResolver.setDefaultThemeName(defaultThemeName);
        TicketGrantingCookieProperties tgc = this.casProperties.getTgc();
        CookieThemeResolver cookieThemeResolver = new CookieThemeResolver();
        cookieThemeResolver.setDefaultThemeName(defaultThemeName);
        cookieThemeResolver.setCookieDomain(tgc.getDomain());
        cookieThemeResolver.setCookieHttpOnly(tgc.isHttpOnly());
        cookieThemeResolver.setCookieMaxAge(Integer.valueOf(tgc.getMaxAge()));
        cookieThemeResolver.setCookiePath(tgc.getPath());
        cookieThemeResolver.setCookieSecure(tgc.isSecure());
        RegisteredServiceThemeResolver serviceThemeResolver = new RegisteredServiceThemeResolver((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject(), this.casProperties, serviceThemeResolverSupportedBrowsers.get().entrySet().stream().collect(Collectors.toMap(entry -> Pattern.compile((String)entry.getKey()), Map.Entry::getValue)));
        serviceThemeResolver.setDefaultThemeName(defaultThemeName);
        RequestHeaderThemeResolver header = new RequestHeaderThemeResolver(this.casProperties.getTheme().getParamName());
        header.setDefaultThemeName(defaultThemeName);
        ChainingThemeResolver chainingThemeResolver = new ChainingThemeResolver();
        chainingThemeResolver.addResolver((ThemeResolver)cookieThemeResolver).addResolver((ThemeResolver)sessionThemeResolver).addResolver((ThemeResolver)header).addResolver((ThemeResolver)serviceThemeResolver).addResolver((ThemeResolver)fixedResolver);
        chainingThemeResolver.setDefaultThemeName(defaultThemeName);
        return chainingThemeResolver;
    }

    @Bean
    @ConditionalOnMissingBean(name={"themesStaticResourcesWebMvcConfigurer"})
    public WebMvcConfigurer themesStaticResourcesWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                List templatePrefixes = CasThemesConfiguration.this.casProperties.getView().getTemplatePrefixes();
                if (!templatePrefixes.isEmpty()) {
                    ResourceHandlerRegistration registration = registry.addResourceHandler(new String[]{"/**"});
                    Resource[] resources = (Resource[])templatePrefixes.stream().map(prefix -> StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0])).map(Unchecked.function(ResourceUtils::getRawResourceFrom)).toArray(Resource[]::new);
                    LOGGER.debug("Adding resource handler for resources [{}]", (Object[])resources);
                    registration.addResourceLocations(templatePrefixes.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
                    registration.addResourceLocations(CasThemesConfiguration.this.webProperties.getResources().getStaticLocations());
                    FunctionUtils.doIfNotNull((Object)CasThemesConfiguration.this.webProperties.getResources().getCache().getPeriod(), period -> registration.setCachePeriod(Integer.valueOf((int)period.getSeconds())));
                    registration.setCacheControl(CasThemesConfiguration.this.webProperties.getResources().getCache().getCachecontrol().toHttpCacheControl());
                    registration.setUseLastModified(true);
                    boolean cache = CasThemesConfiguration.this.thymeleafProperties.getIfAvailable() != null && ((ThymeleafProperties)CasThemesConfiguration.this.thymeleafProperties.getObject()).isCache();
                    ResourceChainRegistration chainRegistration = registration.resourceChain(cache);
                    PathResourceResolver resolver = new PathResourceResolver();
                    resolver.setAllowedLocations(resources);
                    chainRegistration.addResolver((ResourceResolver)resolver);
                }
            }
        };
    }
}

