/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.config;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.throttle.ThrottleProperties;
import org.apereo.cas.web.support.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.web.support.AuthenticationThrottlingExecutionPlanConfigurer;
import org.apereo.cas.web.support.DefaultAuthenticationThrottlingExecutionPlan;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionByIpAddressHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionCleaner;
import org.apereo.cas.web.support.NoOpThrottledSubmissionHandlerInterceptor;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration(value="casThrottlingConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureAfter(value={CasCoreUtilConfiguration.class})
public class CasThrottlingConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasThrottlingConfiguration.class);
    @Autowired
    @Qualifier(value="auditTrailExecutionPlan")
    private ObjectProvider<AuditTrailExecutionPlan> auditTrailExecutionPlan;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @ConditionalOnMissingBean(name={"throttleSubmissionMap"})
    @Bean
    @Lazy
    public ConcurrentMap throttleSubmissionMap() {
        return new ConcurrentHashMap();
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"authenticationThrottle"})
    @Bean
    @Lazy
    public ThrottledSubmissionHandlerInterceptor authenticationThrottle() {
        ThrottleProperties throttle = this.casProperties.getAuthn().getThrottle();
        if (throttle.getFailure().getRangeSeconds() <= 0 && throttle.getFailure().getThreshold() <= 0) {
            LOGGER.debug("Authentication throttling is disabled since no range-seconds or failure-threshold is defined");
            return new NoOpThrottledSubmissionHandlerInterceptor();
        }
        if (StringUtils.isNotBlank((CharSequence)throttle.getUsernameParameter())) {
            LOGGER.debug("Activating authentication throttling based on IP address and username...");
            return new InMemoryThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(throttle.getFailure().getThreshold(), throttle.getFailure().getRangeSeconds(), throttle.getUsernameParameter(), throttle.getFailure().getCode(), (AuditTrailExecutionPlan)this.auditTrailExecutionPlan.getIfAvailable(), throttle.getAppcode(), this.throttleSubmissionMap());
        }
        LOGGER.debug("Activating authentication throttling based on IP address...");
        return new InMemoryThrottledSubmissionByIpAddressHandlerInterceptorAdapter(throttle.getFailure().getThreshold(), throttle.getFailure().getRangeSeconds(), throttle.getUsernameParameter(), throttle.getFailure().getCode(), (AuditTrailExecutionPlan)this.auditTrailExecutionPlan.getIfAvailable(), throttle.getAppcode(), this.throttleSubmissionMap());
    }

    @Autowired
    @ConditionalOnMissingBean(name={"authenticationThrottlingExecutionPlan"})
    @Bean
    public AuthenticationThrottlingExecutionPlan authenticationThrottlingExecutionPlan(List<AuthenticationThrottlingExecutionPlanConfigurer> configurers) {
        DefaultAuthenticationThrottlingExecutionPlan plan = new DefaultAuthenticationThrottlingExecutionPlan();
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Registering authentication throttler [{}]", (Object)name);
            c.configureAuthenticationThrottlingExecutionPlan((AuthenticationThrottlingExecutionPlan)plan);
        });
        return plan;
    }

    @Bean
    @Autowired
    public Runnable throttleSubmissionCleaner(@Qualifier(value="authenticationThrottlingExecutionPlan") AuthenticationThrottlingExecutionPlan plan) {
        return new InMemoryThrottledSubmissionCleaner(plan);
    }

    @ConditionalOnMissingBean(name={"authenticationThrottlingExecutionPlanConfigurer"})
    @Bean
    @Order(value=0)
    public AuthenticationThrottlingExecutionPlanConfigurer authenticationThrottlingExecutionPlanConfigurer() {
        return new AuthenticationThrottlingExecutionPlanConfigurer(){

            public void configureAuthenticationThrottlingExecutionPlan(AuthenticationThrottlingExecutionPlan plan) {
                plan.registerAuthenticationThrottleInterceptor((HandlerInterceptor)CasThrottlingConfiguration.this.authenticationThrottle());
            }
        };
    }
}

