/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.throttle.ThrottleProperties;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlanConfigurer;
import org.apereo.cas.throttle.DefaultAuthenticationThrottlingExecutionPlan;
import org.apereo.cas.throttle.DefaultThrottledRequestResponseHandler;
import org.apereo.cas.throttle.ThrottledRequestExecutor;
import org.apereo.cas.throttle.ThrottledRequestResponseHandler;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionByIpAddressHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionCleaner;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerConfigurationContext;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerEndpoint;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration(value="casThrottlingConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureAfter(value={CasCoreUtilConfiguration.class})
public class CasThrottlingConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasThrottlingConfiguration.class);
    @Autowired
    @Qualifier(value="auditTrailExecutionPlan")
    private ObjectProvider<AuditTrailExecutionPlan> auditTrailExecutionPlan;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"throttledRequestResponseHandler"})
    public ThrottledRequestResponseHandler throttledRequestResponseHandler() {
        ThrottleProperties throttle = this.casProperties.getAuthn().getThrottle();
        return new DefaultThrottledRequestResponseHandler(throttle.getUsernameParameter());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"throttledRequestExecutor"})
    public ThrottledRequestExecutor throttledRequestExecutor() {
        return ThrottledRequestExecutor.noOp();
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"throttleSubmissionMap"})
    @Bean
    public ConcurrentMap throttleSubmissionMap() {
        return new ConcurrentHashMap();
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"authenticationThrottle"})
    @Bean
    public ThrottledSubmissionHandlerInterceptor authenticationThrottle() {
        ThrottleProperties throttle = this.casProperties.getAuthn().getThrottle();
        if (throttle.getFailure().getRangeSeconds() <= 0 && throttle.getFailure().getThreshold() <= 0) {
            LOGGER.trace("Authentication throttling is disabled since no range-seconds or failure-threshold is defined");
            return ThrottledSubmissionHandlerInterceptor.noOp();
        }
        ThrottledSubmissionHandlerConfigurationContext context = ThrottledSubmissionHandlerConfigurationContext.builder().failureThreshold(throttle.getFailure().getThreshold()).failureRangeInSeconds(throttle.getFailure().getRangeSeconds()).usernameParameter(throttle.getUsernameParameter()).authenticationFailureCode(throttle.getFailure().getCode()).auditTrailExecutionPlan((AuditTrailExecutionPlan)this.auditTrailExecutionPlan.getObject()).applicationCode(throttle.getAppCode()).throttledRequestResponseHandler(this.throttledRequestResponseHandler()).throttledRequestExecutor(this.throttledRequestExecutor()).build();
        if (StringUtils.isNotBlank((CharSequence)throttle.getUsernameParameter())) {
            LOGGER.trace("Activating authentication throttling based on IP address and username...");
            return new InMemoryThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(context, this.throttleSubmissionMap());
        }
        LOGGER.trace("Activating authentication throttling based on IP address...");
        return new InMemoryThrottledSubmissionByIpAddressHandlerInterceptorAdapter(context, this.throttleSubmissionMap());
    }

    @Autowired
    @ConditionalOnMissingBean(name={"authenticationThrottlingExecutionPlan"})
    @Bean
    public AuthenticationThrottlingExecutionPlan authenticationThrottlingExecutionPlan(List<AuthenticationThrottlingExecutionPlanConfigurer> configurers) {
        DefaultAuthenticationThrottlingExecutionPlan plan = new DefaultAuthenticationThrottlingExecutionPlan();
        configurers.forEach(c -> {
            LOGGER.trace("Registering authentication throttler [{}]", (Object)c.getName());
            c.configureAuthenticationThrottlingExecutionPlan((AuthenticationThrottlingExecutionPlan)plan);
        });
        return plan;
    }

    @Bean
    @Autowired
    public Runnable throttleSubmissionCleaner(@Qualifier(value="authenticationThrottlingExecutionPlan") AuthenticationThrottlingExecutionPlan plan) {
        return new InMemoryThrottledSubmissionCleaner(plan);
    }

    @ConditionalOnMissingBean(name={"authenticationThrottlingExecutionPlanConfigurer"})
    @Bean
    @Order(value=0)
    public AuthenticationThrottlingExecutionPlanConfigurer authenticationThrottlingExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationThrottleInterceptor((HandlerInterceptor)this.authenticationThrottle());
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public ThrottledSubmissionHandlerEndpoint throttledSubmissionHandlerEndpoint(@Qualifier(value="authenticationThrottlingExecutionPlan") AuthenticationThrottlingExecutionPlan plan) {
        return new ThrottledSubmissionHandlerEndpoint(this.casProperties, plan);
    }
}

