/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.authentication.principal;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceResponseBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.TokenTicketBuilder;
import org.apereo.cas.token.authentication.principal.TokenWebApplicationService;
import org.apereo.cas.web.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenWebApplicationServiceResponseBuilder
extends WebApplicationServiceResponseBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenWebApplicationServiceResponseBuilder.class);
    private static final long serialVersionUID = -2863268279032438778L;
    private final transient TokenTicketBuilder tokenTicketBuilder;

    public TokenWebApplicationServiceResponseBuilder(ServicesManager servicesManager, TokenTicketBuilder tokenTicketBuilder, UrlValidator urlValidator) {
        super(servicesManager, urlValidator);
        this.tokenTicketBuilder = tokenTicketBuilder;
    }

    protected WebApplicationService buildInternal(WebApplicationService service, Map<String, String> parameters) {
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
        boolean tokenAsResponse = RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET.isAssignedTo(registeredService);
        boolean ticketIdAvailable = TokenWebApplicationServiceResponseBuilder.isTicketIdAvailable(parameters);
        if (!tokenAsResponse || !ticketIdAvailable) {
            if (ticketIdAvailable) {
                LOGGER.debug("Registered service [{}] is not configured to issue JWTs for service tickets. Make sure the service property [{}] is defined and set to true", (Object)registeredService, (Object)RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET.getPropertyName());
            }
            return super.buildInternal(service, parameters);
        }
        String jwt = this.generateToken(service, parameters);
        TokenWebApplicationService jwtService = new TokenWebApplicationService(service.getId(), service.getOriginalUrl(), service.getArtifactId());
        jwtService.setFormat(service.getFormat());
        jwtService.setLoggedOutAlready(service.isLoggedOutAlready());
        parameters.put("ticket", jwt);
        parameters.put(Response.ResponseType.REDIRECT.name().toLowerCase(), Boolean.TRUE.toString());
        return jwtService;
    }

    private static boolean isTicketIdAvailable(Map<String, String> parameters) {
        return StringUtils.isNotBlank((CharSequence)parameters.get("ticket"));
    }

    protected String generateToken(WebApplicationService service, Map<String, String> parameters) {
        String ticketId = parameters.get("ticket");
        return this.tokenTicketBuilder.build(ticketId, service);
    }
}

