/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import lombok.Generated;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.PseudoPlatformTransactionManager;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorCoreProperties;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustCipherExecutor;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceNamingStrategy;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.keys.DefaultMultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.keys.LegacyMultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.storage.InMemoryMultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.storage.JsonMultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.storage.MultifactorAuthenticationTrustStorageCleaner;
import org.apereo.cas.trusted.web.MultifactorAuthenticationTrustReportEndpoint;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnMatchingHostname;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(value="multifactorAuthnTrustConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureAfter(value={CasCoreUtilConfiguration.class})
public class MultifactorAuthnTrustConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthnTrustConfiguration.class);
    private static final int INITIAL_CACHE_SIZE = 50;
    private static final long MAX_CACHE_SIZE = 1000000L;
    @Autowired
    @Qualifier(value="ticketCreationActionResolver")
    private ObjectProvider<AuditActionResolver> ticketCreationActionResolver;
    @Autowired
    @Qualifier(value="returnValueResourceResolver")
    private ObjectProvider<AuditResourceResolver> returnValueResourceResolver;
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"mfaTrustDeviceNamingStrategy"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationTrustedDeviceNamingStrategy mfaTrustDeviceNamingStrategy() {
        return MultifactorAuthenticationTrustedDeviceNamingStrategy.random();
    }

    @ConditionalOnMissingBean(name={"mfaTrustEngine"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationTrustStorage mfaTrustEngine() {
        TrustedDevicesMultifactorProperties trusted = this.casProperties.getAuthn().getMfa().getTrusted();
        LoadingCache storage = Caffeine.newBuilder().initialCapacity(50).maximumSize(1000000L).expireAfter((Expiry)new MultifactorAuthenticationTrustRecordExpiry()).build(s -> {
            LOGGER.error("Load operation of the cache is not supported.");
            return null;
        });
        return (MultifactorAuthenticationTrustStorage)FunctionUtils.doIf((trusted.getJson().getLocation() != null ? 1 : 0) != 0, () -> {
            LOGGER.debug("Storing trusted device records inside the JSON resource [{}]", (Object)trusted.getJson().getLocation());
            return new JsonMultifactorAuthenticationTrustStorage(this.casProperties.getAuthn().getMfa().getTrusted(), this.mfaTrustCipherExecutor(), trusted.getJson().getLocation(), this.mfaTrustRecordKeyGenerator());
        }, () -> {
            LOGGER.warn("Storing trusted device records in runtime memory. Changes and records will be lost upon CAS restarts");
            return new InMemoryMultifactorAuthenticationTrustStorage(this.casProperties.getAuthn().getMfa().getTrusted(), this.mfaTrustCipherExecutor(), storage, this.mfaTrustRecordKeyGenerator());
        }).get();
    }

    @ConditionalOnMissingBean(name={"transactionManagerMfaAuthnTrust"})
    @Bean
    public PlatformTransactionManager transactionManagerMfaAuthnTrust() {
        return new PseudoPlatformTransactionManager();
    }

    @ConditionalOnMissingBean(name={"mfaTrustRecordKeyGenerator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationTrustRecordKeyGenerator mfaTrustRecordKeyGenerator() {
        TrustedDevicesMultifactorCoreProperties.TrustedDevicesKeyGeneratorTypes type = this.casProperties.getAuthn().getMfa().getTrusted().getCore().getKeyGeneratorType();
        if (type == TrustedDevicesMultifactorCoreProperties.TrustedDevicesKeyGeneratorTypes.DEFAULT) {
            return new DefaultMultifactorAuthenticationTrustRecordKeyGenerator();
        }
        return new LegacyMultifactorAuthenticationTrustRecordKeyGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"mfaTrustCipherExecutor"})
    public CipherExecutor mfaTrustCipherExecutor() {
        EncryptionJwtSigningJwtCryptographyProperties crypto = this.casProperties.getAuthn().getMfa().getTrusted().getCrypto();
        if (crypto.isEnabled()) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, MultifactorAuthenticationTrustCipherExecutor.class);
        }
        LOGGER.info("Multifactor trusted authentication record encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of trusted authentication records for MFA");
        return CipherExecutor.noOp();
    }

    @ConditionalOnMatchingHostname(name="cas.authn.mfa.trusted.cleaner.schedule.enabled-on-host")
    @ConditionalOnProperty(prefix="cas.authn.mfa.trusted.cleaner.schedule", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(name={"mfaTrustStorageCleaner"})
    @Bean
    public MultifactorAuthenticationTrustStorageCleaner mfaTrustStorageCleaner() {
        return new MultifactorAuthenticationTrustStorageCleaner(this.mfaTrustEngine());
    }

    @Bean
    public AuditTrailRecordResolutionPlanConfigurer casMfaTrustAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditResourceResolver("TRUSTED_AUTHENTICATION_RESOURCE_RESOLVER", (AuditResourceResolver)this.returnValueResourceResolver.getObject());
            plan.registerAuditActionResolver("TRUSTED_AUTHENTICATION_ACTION_RESOLVER", (AuditActionResolver)this.ticketCreationActionResolver.getObject());
        };
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public MultifactorAuthenticationTrustReportEndpoint mfaTrustedDevicesReportEndpoint() {
        return new MultifactorAuthenticationTrustReportEndpoint(this.casProperties, this.mfaTrustEngine());
    }

    private static class MultifactorAuthenticationTrustRecordExpiry
    implements Expiry<String, MultifactorAuthenticationTrustRecord> {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustRecordExpiry.class);

        private MultifactorAuthenticationTrustRecordExpiry() {
        }

        public long expireAfterCreate(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime) {
            if (value.getExpirationDate() == null) {
                LOGGER.trace("Multifactor trust record [{}] will never expire", (Object)value);
                return Long.MAX_VALUE;
            }
            if (value.isExpired()) {
                LOGGER.trace("Multifactor trust record [{}] is expired", (Object)value);
                return 0L;
            }
            try {
                ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
                ZonedDateTime zonedExp = DateTimeUtils.zonedDateTimeOf((Date)value.getExpirationDate()).truncatedTo(ChronoUnit.SECONDS);
                long nanos = Duration.between(now, zonedExp).toNanos();
                LOGGER.trace("Multifactor trust record [{}] expires in [{}] nanoseconds", (Object)value, (Object)nanos);
                return nanos;
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
                LOGGER.debug("Multifactor trust record [{}] will never expire", (Object)value);
                return Long.MAX_VALUE;
            }
        }

        public long expireAfterUpdate(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime, @NonNegative long currentDuration) {
            return this.expireAfterCreate(key, value, currentTime);
        }

        public long expireAfterRead(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime, @NonNegative long currentDuration) {
            return this.expireAfterCreate(key, value, currentTime);
        }
    }
}

