/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.config;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.trusted.authentication.DefaultMultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceNamingStrategy;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationPrepareTrustDeviceViewAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationSetTrustAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationVerifyTrustAction;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.webflow.execution.Action;

@Configuration(value="multifactorAuthnTrustWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class MultifactorAuthnTrustWebflowConfiguration {
    @Autowired
    @Qualifier(value="deviceFingerprintStrategy")
    private ObjectProvider<DeviceFingerprintStrategy> deviceFingerprintStrategy;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="mfaTrustDeviceNamingStrategy")
    private ObjectProvider<MultifactorAuthenticationTrustedDeviceNamingStrategy> mfaTrustDeviceNamingStrategy;
    @Autowired
    @Qualifier(value="mfaTrustEngine")
    private ObjectProvider<MultifactorAuthenticationTrustStorage> mfaTrustEngine;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;

    @ConditionalOnMissingBean(name={"mfaTrustedDeviceBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator() {
        return new DefaultMultifactorAuthenticationTrustedDeviceBypassEvaluator((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }

    @ConditionalOnMissingBean(name={"mfaSetTrustAction"})
    @Bean
    @RefreshScope
    public Action mfaSetTrustAction() {
        return new MultifactorAuthenticationSetTrustAction((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject(), (DeviceFingerprintStrategy)this.deviceFingerprintStrategy.getObject(), this.casProperties.getAuthn().getMfa().getTrusted(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), this.mfaTrustedDeviceBypassEvaluator());
    }

    @ConditionalOnMissingBean(name={"mfaVerifyTrustAction"})
    @Bean
    @RefreshScope
    public Action mfaVerifyTrustAction() {
        return new MultifactorAuthenticationVerifyTrustAction((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject(), (DeviceFingerprintStrategy)this.deviceFingerprintStrategy.getObject(), this.casProperties.getAuthn().getMfa().getTrusted(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), this.mfaTrustedDeviceBypassEvaluator());
    }

    @ConditionalOnMissingBean(name={"mfaPrepareTrustDeviceViewAction"})
    @Bean
    @RefreshScope
    public Action mfaPrepareTrustDeviceViewAction() {
        return new MultifactorAuthenticationPrepareTrustDeviceViewAction((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject(), (DeviceFingerprintStrategy)this.deviceFingerprintStrategy.getObject(), this.casProperties.getAuthn().getMfa().getTrusted(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject(), (ServicesManager)this.servicesManager.getObject(), this.mfaTrustedDeviceBypassEvaluator(), (MultifactorAuthenticationTrustedDeviceNamingStrategy)this.mfaTrustDeviceNamingStrategy.getObject());
    }
}

