/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.DeviceFingerprintProperties;
import org.apereo.cas.trusted.util.cipher.CookieDeviceFingerprintComponentCipherExecutor;
import org.apereo.cas.trusted.web.flow.fingerprint.ClientIpDeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.flow.fingerprint.CookieDeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.flow.fingerprint.DefaultDeviceFingerprintStrategy;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.apereo.cas.trusted.web.flow.fingerprint.GeoLocationDeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.flow.fingerprint.UserAgentDeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.support.TrustedDeviceCookieRetrievingCookieGenerator;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.Base64RandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.mgmr.EncryptedCookieValueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="multifactorAuthnTrustedDeviceFingerprintConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class MultifactorAuthnTrustedDeviceFingerprintConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthnTrustedDeviceFingerprintConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="geoLocationService")
    private ObjectProvider<GeoLocationService> geoLocationService;

    @ConditionalOnProperty(prefix="cas.authn.mfa.trusted.device-fingerprint.client-ip", name={"enabled"}, havingValue="true")
    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"deviceFingerprintClientIpComponentExtractor"})
    public DeviceFingerprintComponentManager deviceFingerprintClientIpComponentExtractor() {
        DeviceFingerprintProperties.ClientIp properties = this.casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getClientIp();
        ClientIpDeviceFingerprintComponentManager component = new ClientIpDeviceFingerprintComponentManager();
        component.setOrder(properties.getOrder());
        return component;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"deviceFingerprintGeoLocationComponentExtractor"})
    @ConditionalOnProperty(prefix="cas.authn.mfa.trusted.device-fingerprint.geolocation", name={"enabled"}, havingValue="true")
    public DeviceFingerprintComponentManager deviceFingerprintGeoLocationComponentExtractor() {
        DeviceFingerprintProperties.GeoLocation properties = this.casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getGeolocation();
        GeoLocationDeviceFingerprintComponentManager component = new GeoLocationDeviceFingerprintComponentManager((GeoLocationService)this.geoLocationService.getIfAvailable());
        component.setOrder(properties.getOrder());
        return component;
    }

    @ConditionalOnProperty(prefix="cas.authn.mfa.trusted.device-fingerprint.cookie", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"deviceFingerprintCookieComponentExtractor"})
    public DeviceFingerprintComponentManager deviceFingerprintCookieComponentExtractor() {
        DeviceFingerprintProperties.Cookie properties = this.casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie();
        CookieDeviceFingerprintComponentManager component = new CookieDeviceFingerprintComponentManager(this.deviceFingerprintCookieGenerator(), this.deviceFingerprintCookieRandomStringGenerator());
        component.setOrder(properties.getOrder());
        return component;
    }

    @ConditionalOnProperty(prefix="cas.authn.mfa.trusted.device-fingerprint.cookie", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(name={"deviceFingerprintCookieGenerator"})
    @Bean
    @RefreshScope
    public CasCookieBuilder deviceFingerprintCookieGenerator() {
        DeviceFingerprintProperties.Cookie cookie = this.casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie();
        return new TrustedDeviceCookieRetrievingCookieGenerator(CookieUtils.buildCookieGenerationContext((CookieProperties)cookie), this.deviceFingerprintCookieValueManager());
    }

    @ConditionalOnProperty(prefix="cas.authn.mfa.trusted.device-fingerprint.user-agent", name={"enabled"}, havingValue="true")
    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"deviceFingerprintUserAgentComponentExtractor"})
    public DeviceFingerprintComponentManager deviceFingerprintUserAgentComponentExtractor() {
        DeviceFingerprintProperties.UserAgent properties = this.casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getUserAgent();
        UserAgentDeviceFingerprintComponentManager component = new UserAgentDeviceFingerprintComponentManager();
        component.setOrder(properties.getOrder());
        return component;
    }

    @ConditionalOnMissingBean(name={"deviceFingerprintStrategy"})
    @Bean(value={"deviceFingerprintStrategy"})
    @RefreshScope
    public DeviceFingerprintStrategy deviceFingerprintStrategy(List<DeviceFingerprintComponentManager> extractors) {
        DeviceFingerprintProperties properties = this.casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint();
        return new DefaultDeviceFingerprintStrategy(extractors, properties.getComponentSeparator());
    }

    @ConditionalOnMissingBean(name={"deviceFingerprintCookieRandomStringGenerator"})
    @Bean
    public RandomStringGenerator deviceFingerprintCookieRandomStringGenerator() {
        return new Base64RandomStringGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(name={"deviceFingerprintCookieValueManager"})
    public CookieValueManager deviceFingerprintCookieValueManager() {
        return new EncryptedCookieValueManager(this.deviceFingerprintCookieCipherExecutor());
    }

    @ConditionalOnMissingBean(name={"deviceFingerprintCookieCipherExecutor"})
    @Bean
    @RefreshScope
    public CipherExecutor deviceFingerprintCookieCipherExecutor() {
        EncryptionJwtSigningJwtCryptographyProperties crypto = this.casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie().getCrypto();
        boolean enabled = crypto.isEnabled();
        if (!enabled && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey())) {
            LOGGER.warn("Token encryption/signing is not enabled explicitly in the configuration, yet signing/encryption keys are defined for operations. CAS will proceed to enable the cookie encryption/signing functionality.");
            enabled = true;
        }
        if (enabled) {
            return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, CookieDeviceFingerprintComponentCipherExecutor.class);
        }
        return CipherExecutor.noOp();
    }
}

