/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f;

import com.yubico.u2f.U2F;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.SignRequestData;
import com.yubico.u2f.data.messages.SignResponse;
import com.yubico.u2f.exceptions.DeviceCompromisedException;
import com.yubico.u2f.exceptions.U2fAuthenticationException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.u2f.U2FTokenCredential;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;

public class U2FAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private final U2F u2f = new U2F();
    private final U2FDeviceRepository u2FDeviceRepository;

    public U2FAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, U2FDeviceRepository u2FDeviceRepository, Integer order) {
        super(name, servicesManager, principalFactory, order);
        this.u2FDeviceRepository = u2FDeviceRepository;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws PreventedException {
        U2FTokenCredential tokenCredential = (U2FTokenCredential)credential;
        Authentication authentication = WebUtils.getInProgressAuthentication();
        if (authentication == null) {
            throw new IllegalArgumentException("CAS has no reference to an authentication event to locate a principal");
        }
        Principal principal = this.principalFactory.createPrincipal(authentication.getPrincipal().getId());
        DeviceRegistration registration = null;
        try {
            SignResponse authenticateResponse = SignResponse.fromJson((String)tokenCredential.getToken());
            String requestId = authenticateResponse.getRequestId();
            String authJson = this.u2FDeviceRepository.getDeviceAuthenticationRequest(requestId, principal.getId());
            if (StringUtils.isBlank((CharSequence)authJson)) {
                throw new PreventedException("Could not get device authentication request from repository for request id " + requestId);
            }
            SignRequestData authenticateRequest = SignRequestData.fromJson((String)authJson);
            Collection registeredDevices = this.u2FDeviceRepository.getRegisteredDevices(principal.getId());
            if (registeredDevices.isEmpty()) {
                throw new PreventedException("No registered devices could be found for " + principal.getId());
            }
            registration = this.u2f.finishSignature(authenticateRequest, authenticateResponse, (Iterable)registeredDevices);
            AuthenticationHandlerExecutionResult authenticationHandlerExecutionResult = this.createHandlerResult((Credential)tokenCredential, principal);
            return authenticationHandlerExecutionResult;
        }
        catch (U2fBadInputException e) {
            throw new PreventedException("Could not accept/parse u2f request: " + e.getMessage(), (Throwable)e);
        }
        catch (DeviceCompromisedException e) {
            registration = e.getDeviceRegistration();
            throw new PreventedException("Device possibly compromised and therefore blocked: " + e.getMessage(), (Throwable)e);
        }
        catch (U2fAuthenticationException e) {
            throw new PreventedException("Could not authenticate device: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (registration != null) {
                this.u2FDeviceRepository.authenticateDevice(principal.getId(), registration);
            }
        }
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return U2FTokenCredential.class.isAssignableFrom(clazz);
    }

    public boolean supports(Credential credential) {
        return U2FTokenCredential.class.isAssignableFrom(credential.getClass());
    }
}

