/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.web.flow;

import com.yubico.u2f.U2F;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.RegisterRequestData;
import com.yubico.u2f.data.messages.RegisterResponse;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class U2FAccountSaveRegistrationAction
extends AbstractAction {
    private final U2F u2f = new U2F();
    private final U2FDeviceRepository u2FDeviceRepository;

    public U2FAccountSaveRegistrationAction(U2FDeviceRepository u2FDeviceRepository) {
        this.u2FDeviceRepository = u2FDeviceRepository;
    }

    protected Event doExecute(RequestContext requestContext) {
        Principal p = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
        String response = requestContext.getRequestParameters().get("tokenResponse");
        RegisterResponse registerResponse = RegisterResponse.fromJson((String)response);
        String regReqJson = this.u2FDeviceRepository.getDeviceRegistrationRequest(registerResponse.getRequestId(), p.getId());
        RegisterRequestData registerRequestData = RegisterRequestData.fromJson((String)regReqJson);
        DeviceRegistration registration = this.u2f.finishRegistration(registerRequestData, registerResponse);
        this.u2FDeviceRepository.registerDevice(p.getId(), registration);
        return this.success();
    }
}

